 
#include <math.h>
#include <assert.h>

#include "hfloatfu.h"


void
theta3_qinv(ulong q, hfloat &th3)
//
// return theta3(1/q)
//
// th3(q) := \sum_{n=-\infty}^{\infty}{q^{n^2}}
//  = 1 + 2*\sum_{n=1}^{\infty}{q^{n^2}}
//  = 2*(1 + \sum_{n=1}^{\infty}{q^{n^2}}) - 1 
//
{
    if ( q==hfloat::radix() )
    {
        th3 = 1;
        //        th3.sign( 1 );
        //        th3.exp( 0 );
        //        th3.set_limb()

        ulong  k = 1;
        while ( 1 )
        {
            ulong s = k*k;

            //            if ( k<=3 )
            //            {
            //                print("\n",th3,16);
            //                cout << " k=" << k << "  s=" << s << endl;
            //            }

            if ( s>=th3.prec() )  break;
            th3.set_limb(s,1);
            k++;
        }

        th3 *= 2;

        th3 -= 1;
    }
    else
    {
        assert( 0 *(int)"not implemented" );
    }

}
//============ end THETA3_QINV =========================


void
theta2_qinv(ulong q, hfloat &th2)
//
// return theta2(1/q)
//
// th2(q) := \sum_{n=-\infty}^{\infty}{q^{(n+1/2)^2}}
//  = 0 + 2*\sum_{n=0}^{\infty}{q^{(n+1/2)^2}}
//  ( if q==b^4 )
//  = 2*\sum_{n=0}^{\infty}{b^{4n^2+4n+1}}
//  = b*2*\sum_{n=1}^{\infty}{q^{n^2+n}}
//  = (1+\sum_{n=1}^{\infty}{q^{n^2+n}}) * 2 * b
//
{
    if ( q!=hfloat::radix() )  assert( 0 *(int)"not implemented" );

    ulong  b = (ulong)rint(pow((double)q,0.25));

    if ( q==(b*b*b*b) )  // q == b^4
    {
        th2 = 1;
        
        ulong  k = 1;
        while ( 1 )
        {
            ulong s = k*k+k;
            //            cout << " k=" << k << "  s=" << s << endl;

            if ( s>=th2.prec() )  break;
            th2.set_limb(s,1);
            k++;
        }

        th2 *= 2;
        th2 /= b;
    }
    else
    {
        assert( 0 *(int)"not implemented" );
    }

}
//============= end THETA2_QINV ========================



//    th3(1e-4) = 1.000200000000000200000000000000000002
//    th2(1e-4) = 0.2000000020000000000000002

//    log(1e4) = 9.21034037
//  1/log(1e4) = 0.1085736
// pi/log(1e4) = 0.3410940

//    log(2^16) = 11.0903548
//  1/log(2^16) = 0.0901684
// pi/log(2^16) = 0.28327250


void
pi_by_log_q(long n, hfloat &x, ulong q)
//
// return pi/log(q)
//
// pi/log(q) = AGM(th3(q)^2,th2(q)^2)
// th3(q) := \sum_{n=-\infty}^{\infty}{q^{n^2}}
// th2(q) := \sum_{n=-\infty}^{\infty}{q^{(n+1/2)^2}}
// cf. borwein^2 p.225
//
{
    hfloat th3(n);
    theta3_qinv(q,th3);
    //    print("  th3=",th3,12);
    //    th3 = 1.000200000000000200000000000000000002;  print("corr  th3=",th3,12);
    sqr(th3,th3);
    //    print("th3^2=",th3,12);

    hfloat &th2 = x;
    theta2_qinv(q,th2);
    //    print("  th2=",th2,12);
    //    th2 = 0.2000000020000000000000002;  print("corr  th2=",th2,12);
    sqr(th2,th2);
    //    print("th2^2=",th2,12);


    agm(th3,th2,x);
    //    print("  agm=",x,12);
    //    cout << "pi/log(rx)=" << PI/log(q) << endl;
}
//============== end PI_BY_LOG_Q =======================

