#include <math.h>
#include <std.h>
#include <iostream.h>
#include <assert.h>
#include <values.h>      // for BITS(int), MAXINT

#include "../src/include/hfloatfu.h"
#include "../src/include/mybuiltin.h"
#include "../src/include/workspace.h"

#include "../src/include/hfdatafu.h"


const int  TEST_SQR     = 0;
const int  TEST_MUL_SH  = 0;
const int  TEST_MULSQR  = 1;
const int  TEST_MUL_DIR = 0;
const int  TEST_MUL     = 0;
const int  TEST_DIV_SH  = 0;
const int  TEST_DIV_DIR = 0;
const int  TEST_DIVMOD  = 0;
const int  TEST_FLOOR   = 0;
const int  TEST_2POW    = 0;


int test1(long nn)
{
    int k;
    hfloat a(nn),b(nn),c(nn),d(nn);

    cout<<"\n TEST1 "<<flush;

    k=0;
    a=b=c=d=33;


    if ( TEST_MULSQR )
    {
        a=9;
        b=8;
        mul(a,b,c);
        print("\n a*b=",c,8);
        a.prec(8);
        b.prec(8);
        print("\n a*b=",a*b,8);
        cout<<"-----------------------------"<<endl;

        a.prec(a.size());
        b.prec(b.size());
        a= 90;
        b= 8;
        mul(a,b,c);
        print("\n a*b=",c,8);
        a.prec(8);
        b.prec(8);
        print("\n a*b=",a*b,8);
        cout<<"-----------------------------"<<endl;

        a.prec(a.size());
        b.prec(b.size());
        a= .010;
        b= .999;
        mul(a,b,c);
        print("\n a*b=",c,8);
        a.prec(8);
        b.prec(8);
        print("\n a*b=",a*b,8);
        cout<<"-----------------------------"<<endl;

        a.prec(a.size());
        b.prec(b.size());
        a= 3;
        b= 3;
        mul(a,b,c);
        print("\n a*b=",c,8);
        a.prec(8);
        b.prec(8);
        print("\n a*b=",a*b,8);
        cout<<"-----------------------------"<<endl;

        return 999;
    }


    if ( TEST_SQR )
    {
        i2hfloat(1,a);
        a/=3;
        sqr(a,b);

        a.prec(nn/2);
        print("\n a=\n",a);
        print("\n a^2=\n",b);
    }



    // ---------- factorial  (mult):
    if ( TEST_MUL_SH )
    {
        a=1;
        print("\n ------------- a:\n",a);
        for (k=2; k<=11; ++k)  { mul(a,-k,c); print("\n c:\n",c); copy(c,a); }
        for (k=2; k<=11; ++k)  { div(a,-k,c); print("\n c:\n",c); copy(c,a); }

        a-=1;
        print("\n   0 =?=  a:\n",a);


        cout<<"\n\n";

        a=1;
        print("\n ------------- a:\n",a);
        for (k=66000; k<=66000+44; ++k)  { mul(a,-k,c); print("\n c:\n",c); copy(c,a); }
        for (k=66000; k<=66000+44; ++k)  { div(a,-k,c); print("\n c:\n",c); copy(c,a); }

        a-=1;
        print("\n   0 =?=  a:\n",a);

    }


    // ---------- short division (div):
    if ( TEST_DIV_SH )
    {
        a=1;

        print("\n a==",a,12);

        for (k=2; k<13; ++k)
        {
            div(a,-k,c);
            print("\n c:\n",c,5);
            copy(c,a);
        }

    }

    cout<<endl;

    return 0;
}
//================================ end TEST1 ==========================

