#include <iostream.h>
#include <strstream.h>
#include "ap.h"


// Program to test the modint class

int main (int argc, char *argv[])
{
    int m;
    modint a, b;

    if (argc < 2)
    {
        cerr << "USAGE: modtest m" << endl;
        return 2;
    }

    istrstream s (argv[1]);

    if (!(s >> m))
    {
        cerr << "Invalid argument m: " << argv[1] << endl;
        return 1;
    }

    setmodulus (moduli[m]);

    a = 600000000000ULL;
    b = 600000000000ULL;

    cout << "sizeof (modint) = " << sizeof (modint) << endl;

    cout << a << " * " << 600000000000ULL << " = " << a * 600000000000ULL << " (mod " << modint::modulus << ")" << endl;

    cout << a << " ^ " << b << " = " << pow (a, b) << " (mod " << modint::modulus << ")" << endl;

    cout << 1 << " / " << a << " = " << (b = 1 / a) << " (mod " << modint::modulus << ")" << endl;

    cout << a << " * " << b << " = " << a * b << " (mod " << modint::modulus << ")" << endl;

    cout << "Primitive root of " << modint::modulus << " = " << primitiveroots[m] << endl;

    clearmodulus ();

    return 0;
}
