.386
.model flat

public _bigadd, _bigsub, _bigmul, _bigdiv, _bigcmp, _bigshr

.code

_bigadd proc

    push ecx
    push esi
    push edi

    mov esi, [esp + 20]
    mov edi, [esp + 16]
    mov ecx, [esp + 24]

    clc

    jecxz bigaddcarry

    lea esi, [esi + 4 * ecx]
    lea edi, [edi + 4 * ecx]
    neg ecx

    clc

    bigaddloop:
    mov eax, [esi + 4 * ecx]
    adc [edi + 4 * ecx], eax
    inc ecx
    jnz bigaddloop

    bigaddcarry:

    jnc bigaddend

    mov ecx, [esp + 28]

    jecxz bigaddend

    lea edi, [edi + 4 * ecx]
    not ecx
    inc ecx

    bigaddcarryloop:
    adc dword ptr [edi + 4 * ecx], 0
    jnc bigaddend
    inc ecx
    jnz bigaddcarryloop

    bigaddend:

    mov eax, 0
    adc eax, 0

    pop edi
    pop esi
    pop ecx

    ret

_bigadd endp

_bigsub proc

    push ecx
    push esi
    push edi

    mov esi, [esp + 20]
    mov edi, [esp + 16]
    mov ecx, [esp + 24]

    clc

    jecxz bigsubcarry

    lea esi, [esi + 4 * ecx]
    lea edi, [edi + 4 * ecx]
    neg ecx

    clc

    bigsubloop:
    mov eax, [esi + 4 * ecx]
    sbb [edi + 4 * ecx], eax
    inc ecx
    jnz bigsubloop

    bigsubcarry:

    jnc bigsubend

    mov ecx, [esp + 28]

    jecxz bigsubend

    lea edi, [edi + 4 * ecx]
    not ecx
    inc ecx

    bigsubcarryloop:
    sbb dword ptr [edi + 4 * ecx], 0
    jnc bigsubend
    inc ecx
    jnz bigsubcarryloop

    bigsubend:

    mov eax, 0
    adc eax, 0

    pop edi
    pop esi
    pop ecx

    ret

_bigsub endp

_bigmul proc

    push ebx
    push ecx
    push edx
    push esi
    push edi

    xor ebx, ebx
    mov esi, [esp + 28]
    mov edi, [esp + 24]
    mov ecx, [esp + 36]

    xor edx, edx
    jecxz bigmulend

    lea esi, [esi + 4 * ecx]
    lea edi, [edi + 4 * ecx]
    neg ecx

    bigmulloop:
    mov eax, [esi + 4 * ecx]
    mul dword ptr [esp + 32]
    add eax, ebx
    adc edx, 0
    mov [edi + 4 * ecx], eax
    mov ebx, edx
    inc ecx
    jnz bigmulloop

    bigmulend:

    mov eax, edx

    pop edi
    pop esi
    pop edx
    pop ecx
    pop ebx

    ret

_bigmul endp

_bigdiv proc

    push ebx
    push ecx
    push edx
    push esi
    push edi

    mov ebx, [esp + 32]
    mov esi, [esp + 28]
    mov edi, [esp + 24]
    mov ecx, [esp + 36]

    xor edx, edx

    jecxz bigdivend

    mov eax, [esi + 4 * ecx - 4]
    cmp eax, ebx
    jae bigdivloop
    mov dword ptr [edi + 4 * ecx - 4], 0
    dec ecx
    mov edx, eax

    jecxz bigdivend

    bigdivloop:
    mov eax, [esi + 4 * ecx - 4]
    div ebx
    mov [edi + 4 * ecx - 4], eax
    dec ecx
    jnz bigdivloop

    bigdivend:

    mov eax, edx

    pop edi
    pop esi
    pop edx
    pop ecx
    pop ebx

    ret

_bigdiv endp

_bigshr proc

    push ecx
    push esi
    push edi

    mov esi, [esp + 20]
    mov edi, [esp + 16]
    mov ecx, [esp + 24]

    clc

    jecxz bigshrend

    bigshrloop:
    mov eax, [esi + 4 * ecx - 4]
    rcr eax, 1
    mov [edi + 4 * ecx - 4], eax
    dec ecx
    jnz bigshrloop

    bigshrend:

    mov eax, 0
    adc eax, 0

    pop edi
    pop esi
    pop ecx

    ret

_bigshr endp

_bigcmp proc

    push ecx
    push esi
    push edi

    mov esi, [esp + 20]
    mov edi, [esp + 16]
    mov ecx, [esp + 24]

    jecxz bigcmpend

    bigcmploop:
    mov eax, [edi + 4 * ecx - 4]
    cmp eax, [esi + 4 * ecx - 4]
    jb bigcmpb
    ja bigcmpa
    dec ecx
    jnz bigcmploop

    bigcmpend:
    xor eax, eax

    pop edi
    pop esi
    pop ecx

    ret

    bigcmpb:
    mov eax, -1

    pop edi
    pop esi
    pop ecx

    ret

    bigcmpa:
    mov eax, 1

    pop edi
    pop esi
    pop ecx

    ret

_bigcmp endp

end
