
#include <assert.h>

#include "auxid.h"
#include "hfdata.h"



int i_div_sh(LIMB *cd, ulong cn, uint b, const uint rx, int *r);

#if defined __GNUC__
#define HAVE_IDIVSEMI
int i_div_semi(LIMB *cd, ulong cn, uint b, const uint rx, int *r);
#endif

//#include <iostream.h>


int
dt_div_sh(hfdata &a, ulong ap, ulong u, int *rem)
//
// c=a/b
// rem=a%b
// return= amount of left shift that occured
//
{
    const uint rx=hfdata::rx;
    int dx;


    if( u <= MAX_LIMB )
    {
	dx = i_div_sh(a.dig(),ap,u,rx,rem); 
    }
    else
    {
#if defined HAVE_IDIVSEMI
        //        cout << "/e";
        dx = i_div_semi(a.dig(),ap,u,rx,rem);
#else
        assert( 0 );
#endif
    }


    return dx;
}
//============== end DT_DIV_SH ====================



int
i_div_sh(LIMB *cd, ulong cn, uint b, const uint rx, int *r) // =0
//
// return= amount of left shift that occured
//
{
    assert( b<= MAX_LIMB );

    ulong k;
    ulong zz, rem = 0;

    for (k=0; k<cn; ++k)
    {
        zz  = (ulong)cd[k];
	zz += rx*rem;
        cd[k] = (LIMB)(zz/b);
        rem = zz%b;

        // is not faster:
        /* 
        zz  =  (ulong)cd[k];
	zz +=  (rem*rx);
        cd[k] = (LIMB)(rem=(zz/b));
        rem  = zz-b*rem;
        */
    }

    int f = i_first(cd,cn);

    if ( f )   // normalize 
    {
        i_shift_left(cd,cn,f);
	
	k = f;
	do
	{
	    zz = rx*rem;
	    cd[cn-k] = (LIMB)(zz/b);
	    rem = zz%b;
	}
	while ( --k );
    }

    if ( r )  *r = (int)rem;

    return f;
}
//================== end I_DIV_SH ========================



#if defined HAVE_IDIVSEMI

#undef  UINTLL
#define UINTLL unsigned long long

int
i_div_semi(LIMB *cd, ulong cn, uint b, const uint rx, int *r) // =0
//
// return= amount of left shift that occured
//
{
    ulong k;
    UINTLL zz, rem = 0;

    for (k=0; k<cn; ++k)
    {
        /*
        zz  =  (UINTLL)cd[k];
	zz +=  rx*rem;
        cd[k] = (LIMB)(zz/b);
        rem  = zz%b;
        */

        // faster:
        zz  =  (UINTLL)cd[k];
	zz +=  (rem*rx);
        cd[k] = (LIMB)(rem=(zz/b));
        rem  = zz-b*rem;
    }


    int f = i_first(cd,cn);

    if ( f )   // normalize 
    {
        i_shift_left(cd,cn,f);
	
	k = f;
	do
	{
	    zz = rx*rem;
	    cd[cn-k] = (LIMB)(zz/b);
	    rem = zz%b;
	}
	while ( --k );
    }

    if ( r )  *r = (int)rem;

    return f;
}
//================== end I_DIV_SEMI ========================
#endif

