
#include <assert.h>

#include "hfdatafu.h"
#include "convolut.h"
#include "auxid.h"
#include "mybuiltin.h"
#include "workspace.h"



int
dt_mul_fxt(const hfdata &dta, ulong an, const hfdata &dtb, ulong bn,
           hfdata &dtc, ulong cn)
//
// return: if(right_shift occured) 
//
{
    const LIMB *a = dta.dig();
    const LIMB *b = dtb.dig();
    LIMB *c = dtc.dig();
    unsigned rx = hfdata::rx;

    return i_mul_fxt(a, an, b, bn, c, cn, dtc.dtxdig, rx);
}
//===================== end DT_MUL_FXT ================================



int
i_mul_fxt(const LIMB *a, ulong an, const LIMB *b, ulong bn, 
          LIMB *c, ulong cn, LIMB &xdig, unsigned rx) 
//
// return: if(right_shift occured) 
//
{

    ulong p = MAX(an,bn);
    ulong ldn = ld(p);
    ulong n = (1<<ldn);
    if ( n!=p )  ldn++;
    n = (1<<ldn);  // set n to pow of 2
    ulong ldn2 = ldn+1;
    ulong n2 = (1<<ldn2);

    hfdata::fxtw += 3.0*n2*ldn2;

    double *f = gws.get_ws_doubles(n2);
    double *g = gws.get_ws_doubles(n2);

    id_copy(a,an,f,n2);
    id_copy(b,bn,g,n2);

    ulong qsa,qsb,qsc,qsm=0;  // avoid compiler warning
    if ( hfdata::checkmult )
    {
        qsa = (ulong)d_sumofdigits(f,an,rx-1,0);
        qsb = (ulong)d_sumofdigits(g,bn,rx-1,0);
        //    cout << " qsa="<< qsa << "  qsb="<< qsb << endl;
        qsm = (qsa*qsb)%(ulong)(rx-1);
        //    cout << " qsm="<< qsm;
    }


    hfdata::mulcnvl(f,g,ldn2);

    int cy = d_carry(g,n2,rx);


    if ( hfdata::checkmult )
    {
        qsc = (ulong)d_sumofdigits(g,n2,rx-1,cy);
        //    cout << qsc << " =qsc" << endl;
        assert ( (qsm==qsc)*(int)"checksum error in i_mul_fxt()" );
    }


    int ret;
    if( 0==cy )
    {
        xdig = 0;  // the LIMB that gets shifted out to the right
        di_copy(g,n2,c,cn);
	ret = 0;
    }
    else
    {
        xdig = c[cn-1];  // the LIMB that gets shifted out to the right
	c[0] = cy;
        di_copy(g,n2,c+1,cn-1);
	ret = 1;
    }

    gws.let_ws(f);
    gws.let_ws(g);


    return ret;
}
//===================== end I_MUL_FXT ================================
