
#include <assert.h>

#include "auxid.h"
#include "workspace.h"
#include "hfdata.h"


//#if RADIX_IS_TWO_POW
//#define IMODRAD(x,rx)     ((LIMB)(x & NINE))
//#define IDIVRAD(x,rx)     (x>>LOG2RADIX)
//#else
#define IMODRAD(x,rx)     ((LIMB)(x%rx))
#define IDIVRAD(x,rx)     (x/rx)
//#endif


//#include <iostream.h>

int
dt_mul_sh(hfdata &a, ulong ap, ulong b)
//
// returns how many right shifts happened
//
{
    if( b<=MAX_LIMB )
    {
	return i_mul_sh(a.dig(), ap, b, a.dtxdig, hfdata::rx);
    }
    else
    {
#if defined HAVE_IMULSEMI
        //        cout << "*e";
	return i_mul_semi(a.dig(), ap, b, a.dtxdig, hfdata::rx);
#else
        assert( 0 );
#endif
    }
}
//================ end DT_MUL_SH ======================



int
i_mul_sh(LIMB *ad, ulong an, uint b, LIMB &xdig, const uint rx)
//
// sets xdig to the (last) LIMB that gets shifted out to the right
//
// returns how many right shifts happened
//
{
    assert( b<=MAX_LIMB );

    ulong zz, cy = 0;

    for(ulong k=an-1;  ; --k)
    {
        zz =  (ulong)ad[k];
	zz *= b;
	zz += cy;
        ad[k] = IMODRAD(zz,rx);
        cy    = IDIVRAD(zz,rx);

	if( k==0 )  break;
    }

    xdig = 0;
    int s = 0;
    while( cy )   // overflow ?
    {
        xdig = ad[an-1];
	s++;
	i_shift_right(ad,an);
	ad[0] = IMODRAD(cy,rx);
        cy =    IDIVRAD(cy,rx);
    }

    return s;
}
//=============== end I_MUL_SH ==================



#if defined HAVE_IMULSEMI

#undef  UINTLL
#define UINTLL unsigned long long

int
i_mul_semi(LIMB *ad, ulong an, uint b, LIMB &xdig, const uint rx)
//
// sets xdig to the (last) LIMB that gets shifted out to the right
//
// returns how many shift rights happened
//
{
    UINTLL zz, cy = 0;

    for(ulong k=an-1;  ; --k)
    {
        zz =  (UINTLL)ad[k];
	zz *= b;
	zz += cy;
        ad[k] = IMODRAD(zz,rx);
        cy    = IDIVRAD(zz,rx);

	if( k==0 )  break;
    }

    xdig = 0;
    int s = 0;
    while( cy )   // overflow ?
    {
        xdig = ad[an-1];
	s++;
	i_shift_right(ad,an);
	ad[0] = IMODRAD(cy,rx);
        cy    = IDIVRAD(cy,rx);
    }

    return s;
}
//=============== end I_MUL_SEMI ==================
#endif

