#include <math.h>
#include <iostream.h>

#include "fxt.h"
#include "fxtaux.h"


void 
make_frft_chirp(double *wr, double *wi, double ph0, long nn)
{
    long k,np,nd;
    double phi;

    nd=2*nn;
    phi=0.5*ph0;

    for(np=0,k=0; k<nn; ++k)
    {
        double c,s;

//        n2=(double)k*k;
//        sincos(&c,&s,phi*n2);  
//  possible loss of precision due to huge arguments in sincos 

        sincos(&c,&s,phi*np);
        np+=((k<<1)+1);
        if(np>=nd)
             np-=nd;

        wr[k]=c;
        wi[k]=s;
    }

//    cout<<"\n make_frft_chirp: nn="<<nn<<"  ph0="<<ph0;
//    reimabs_print("\n make_frft_chirp : ",wr,wi,nn);
}
/* ============== end MAKE_FRFT_CHIRP ================ */



void 
frft(double *x, double *y, long n, int is, double v)
//
// fractional (fast) fourier transform
//
// for complex array c[0...n]
// compute \sum_{x=0}^{n}{c_x*exp(is*v*2*i*\pi*x*k/n)}
//  (for v==1.0 this is just the usual fft)
//
//  *** ! UNTESTED ! ***
//
// use n*k == n^2/2 + k^2/2 + -(k-n)^2/2
// (see: nussbaumer: FFT and convolution algorithms 5.1)
// ( could use n*k == -n^2/2 + -k^2/2 + (k+n)^2/2 instead )
// ( ?? n*k == (n+k)^2/4 + -(n-k)^2/4 )
//
// nn is the smallest power of 2 >=2*n
//
// worst case if n=2^x+1:
//   then work is about 12 times a fft of length 2^x
//   and allocated workspace =4*2^x
//
{
    long k,nn,ldn;
    double ph0;
    double *wr,*wi,*fr,*fi;


    ldn=ld(n);

    if(n==(((long)1)<<ldn))
        ldn+=1;
    else
        ldn+=2;

    nn=(1<<ldn);

    fr=new double[nn];
    fi=new double[nn];

    d_copy(x,fr,n); 
    d_null(fr+n,nn-n);
    d_copy(y,fi,n); 
    d_null(fi+n,nn-n);


    wr=new double[nn];
    wi=new double[nn];


//    reimabs_print("\n f : ",fr,fi,nn);

    ph0=is*v*2.0*M_PI/n;  // v==1.0 gives usual fft

    make_frft_chirp(wr,wi,ph0,nn);
//    reimabs_print("\n fft_chirp #1 : ",wr,wi,nn);

    for(k=0; k<n; ++k)
        cmult4(wr[k],wi[k],fr[k],fi[k]);    
//    reimabs_print("\n f*ch : ",fr,fi,nn);


//    make_frft_chirp(wr,wi,-ph0,nn);
    for(k=0; k<n; ++k)  
        wi[k]=-wi[k]; 
//    reimabs_print("\n fft_chirp #2 : ",wr,wi,nn);


    fft_complex_convolution(wr,wi,fr,fi,ldn);
//    reimabs_print("\n (f x ch) : ",fr,fi,nn);


    make_frft_chirp(wr,wi,ph0,nn);
//    reimabs_print("\n fft_chirp #3 : ",wr,wi,nn);


    for(k=0; k<nn; ++k)
        cmult4(fr[k],fi[k],wr[k],wi[k]);    
        
//    reimabs_print("\n frft : ",wr,wi,nn);
//    reimabs_print("\n frft result = ",wr+n,wi+n,n);

    d_copy(wr+n,x,n); 
    d_copy(wi+n,y,n); 

    delete [] wr;
    delete [] wi;

    delete [] fr;
    delete [] fi;

return;
}
/* ============== end FRFT ================ */
