
#include "fxt.h"
#include "fxtaux.h"


void 
fht_fft(double *real, double *imag, ulong ldn, int is)
{
    const ulong n=(1<<ldn);

    if(is<0)
    {   
	const ulong k=n/2;
	for (ulong i=1,j=n-1; i<k; i++,j--)
	{
	    double q,r,s,t;

            sumdiff4(real[i],real[j],q,r);
            sumdiff4(imag[i],imag[j],s,t);
	    
            sumdiff4_05(q,t,real[i],real[j]);
            sumdiff4_05(s,r,imag[j],imag[i]);
	}
    
	fht(real,ldn);
	fht(imag,ldn);
    }
    else
    {
        fht(real,ldn);
        fht(imag,ldn);
    
	const ulong k=n/2;
	for (ulong i=1,j=n-1; i<k; i++,j--)
	{
	    double q,r,s,t;

            sumdiff4(real[i],real[j],q,r);
            sumdiff4(imag[i],imag[j],s,t);

            sumdiff4_05(q,t,real[j],real[i]);
            sumdiff4_05(s,r,imag[i],imag[j]);
	}
    }   
}
/* ========================= end FHT_FFT =================== */


void 
fht_fft0(double *real, double *imag, ulong ldn, int is)
{
    const ulong n=(1<<ldn);

    if(is<0)
    {   
	const ulong k=n/2;
	for (ulong i=1,j=n-1; i<k; i++,j--)
	{
	    /*
	    double q,r,s,t;

            sumdiff4(real[i],0,q,r);
            sumdiff4(imag[i],0,s,t);
	    
            sumdiff4_05(q,t,real[i],real[j]);
            sumdiff4_05(s,r,imag[j],imag[i]);
	    */
            sumdiff4_05(real[i],imag[i],imag[j],real[j]);

            imag[i]=-real[j];
            real[i]= imag[j];
	}
    
	fht(real,ldn);
	fht(imag,ldn);
    }
    else 
    {
        fht0(real,ldn);
      	fht0(imag,ldn);
    
	const ulong k=n/2;
	for (ulong i=1,j=n-1; i<k; i++,j--)
	{
	    double q,r,s,t;

            sumdiff4(real[i],real[j],q,r);
            sumdiff4(imag[i],imag[j],s,t);

            sumdiff4_05(q,t,real[j],real[i]);
            sumdiff4_05(s,r,imag[i],imag[j]);
	}
    }   
}
/* ========================= end FHT_FFT0 =================== */
