#include <math.h>

#include "fxt.h"
#include "fxtaux.h"


void 
fht_spectrum(double *f, ulong ldn)
//
//   power_spectrum made with fht
//
{
    fht(f,ldn);

    const long n=(1<<ldn);
    const long k=n/2;
    for (long i=1,j=n-1; i<k; i++,j--)
    {
        double a,b;

        a = f[i]+f[j];  // real part 
        b = f[i]-f[j];  // imag part

        f[i] = sqrt(a*a+b*b)*0.5;
	//	f[j] = atan2(b,a);  // if you want phases 
    }

    f[0]=sqrt(f[0]*f[0]+f[n/2]*f[n/2]);  // *0.5 ???
}
/* ============= end FHT_SPECTRUM ============ */
