

void
print(char *bla, const double *f, ulong n)
{
    cout<<"\n"<<bla<<endl;

    cout.precision(21);
    for(ulong i=0; i<n; ++i) 
    {
	cout<< i << ": " << f[i] <<endl;
    }
}
//-------------------------------------------

/*
void
testops()
{
    mod a = 1, b = 5;
    int i = 5;
    smod_t s = 5;
    umod_t u = 5;

    a = i; a = s; a = u; a = b;

    a *= i; a /= i; a += i; a -= i;

    a *= s; a /= s; a += s; a -= s;

    a *= u; a /= u; a += u; a -= u;

    a *= b; a /= b; a += b; a -= b;

    a = a+b; a = a-b; a = a*b; a = a/b;

//    cout << " testops(): a=" << a  << endl;

    a = 5;  b = 3;
    cout << " a=" << a << " b=" << b << endl;
    cout << " a+b=" << a+b << " a*b=" << a*b << endl;
    cout << " a-b=" << a-b << " b-a=" << b-a << endl;
    cout << " pow(a,3)=" << pow(a,3) << endl;
}
//-------------------------------------------
*/


void
test_egcd()
{
    smod_t a,b,u,v;
    a = 5712452;
    b = 7340033;

    egcd(a,b,u,v);
}
//-------------------------------------------


//    delete mod::mod_initializer;
//    umod_t m4 = 5*17;
//    umod_t f4[] = {5,17,0};
//    umod_t m4 = 7*17;
//    umod_t f4[] = {7,17,0};
//    umod_t m4 = 4294967297;
//    umod_t f4[] = {641,6700417,0};
//    mod::mod_initializer = new mod_init(m4,f4);
//    mod_info();

//    arith_table(3);

void
arith_table(int q)
{
    // q = 1,2,3 for add,mul,pow

    uint i,k,r;
    umod_t m = mod::modulus;

    switch ( q )
    {
    case 1:  cout << " ADDITION: \n";  break;
    case 2:  cout << " MULTIPLICATION: \n";  break;
    case 3:  cout << " POWERS: \n";  break;
    }

    cout << "[order]";
    for (i=0; i<m; ++i)
    {
        cout.width(3);
        cout << i;
    }
    cout << "\n";

    cout << "-------";
    for (i=0; i<m; ++i)  cout << "---";
    cout << "\n";

    for (i=0; i<m; ++i)
    {
        mod x = i, y = i;
        r = order(x);

        cout << "[";
        cout.width(3);
        cout << r;
        cout << "]: ";

        for (k=0; k<m; ++k)
        {
            cout.width(3);
            switch ( q )
            {
            case 1:  cout << x+mod(k);  break; // add (only semi exciting)
            case 2:  cout << x*mod(k);  break; // mult
            case 3:  cout << pow(x,k);  break; // pow
            }
        }
        cout << "\n";
    }
    
    cout << "\n";
}
//-------------------------------------------

void
make_arith_tables()
{
    int q = 2;

    delete mod::mod_initializer;
    umod_t m1 = 23;
    umod_t f1[] = {23,0};
    mod::mod_initializer = new mod_init(m1,f1);
    mod_info();
    arith_table(q);

    delete mod::mod_initializer;
    umod_t m3 = 15;
    umod_t f3[] = {3,5,0};
    mod::mod_initializer = new mod_init(m3,f3);
    mod_info();
    arith_table(q);

    delete mod::mod_initializer;
    umod_t m2 = 25;
    umod_t f2[] = {5,0};
    mod::mod_initializer = new mod_init(m2,f2);
    mod_info();
    arith_table(q);

    delete mod::mod_initializer;
    umod_t m4 = 27;
    umod_t f4[] = {3,0};
    mod::mod_initializer = new mod_init(m4,f4);
    mod_info();
    arith_table(q);
}
//-------------------------------------------



//    // rabinmiller:
//    for (uint k=0; k<=555; k++)
//    {
//        umod_t z = prime[200+k];
//        cout << z << " --> ";
//        jjassert( prime_q(z) );
//        jjassert( !prime_q(z*17) );
//        jjassert( !prime_q(z*1601) );
//        jjassert( !prime_q(z*11) );
//        jjassert( !prime_q(z*z) );
//    }


//    // sqrt_modp()
//    for (uint k=1; k<=55; k++)
//    {
//        umod_t p = prime[k];
//        cout << " --- p=" << p << "\n";
//        for (uint j=1; j<p; ++j)
//        {
//            cout << " -- j=" << j << "\n";
//            umod_t s = mul_mod(j,j,p);
//            cout << " s=" << s << " == j^2 \n";
//            int k = kronecker(s,p);  jjassert( k==1 );
//
//            umod_t w = sqrt_modp(s,p);
//            cout << " w=" << w << "  == sqrt_mod(s,p)\n";
//
//            umod_t ws = mul_mod(w,w,p);
//            if ( ws!=s )
//            {
//                cout << " ws=" << ws << "  =!= s \n";
//                exit(666);
//            }
//        }
//    }


//    // sqrt_modpp()
//    umod_t p = 3; 
//    jjassert( prime_q(p) );
//    cout << " ----- p=" << p << "\n";
//    long ex = 7;
//    cout << " ----- ex=" << ex << "\n";
//    umod_t m = ipow(p,ex);
//    cout << " ----- m=" << m << "\n";
//    for (uint k=1; k<=20; k++)
//    {
////        cout << " --- k=" << k << "\n";
//
//        umod_t x = m-k;
//        int j = kronecker(x,p);
//        if ( j!=1 )  continue;
//
//        cout << "  x=" << x << "\n";
//        umod_t w = sqrt_modpp(x,p,ex);
//        cout << "  w=" << w << "  == sqrt_mod(x,m)\n";
//        umod_t s = mul_mod(w,w,m);
//        cout << "  s=" << s << "\n";
//
//        jjassert( s==x );
//    }
//    exit(0);


//  // chinese()
//    umod_t m = 1ULL* 65537; // * 7 *11 * 13;
//    factorization ff(m);
//    cout << "m=" << m << " == " << ff << endl;
//    uint n = ff.npr;
//    umod_t x[99];
//    for (uint k=0; k<n; ++k)  { x[k] = k+1; }
//    x[0] = 1;
//    x[1] = 3;
//    umod_t c = chinese(x,ff);
//    cout << " CRT=" << c << endl;
//    for (uint k=0; k<n; ++k)
//    {
//        umod_t mi = ff.factor(k);
//        cout << " x[" << k << "]%mi=" << x[k]%mi; // << endl;
//        umod_t cr = c % mi;
//        cout << " cr[" << k << "]=" << cr << endl;
//        if ( (x[k]%mi)!=cr )  cout << "    !!!" << endl;
//    }


//    // sqrt_modf():
//    umod_t x = m-1;
//    while ( 1 )
//    {
//        cout << " ---- x=" << x << "\n";
//        if ( !is_quadratic_residue(x,ff) )
//        {
//            cout << " order(x)=" << order(x) 
//                 << "  log2(order(x))=" << ld(order(x)) << endl;
//            break;
//        }
//        umod_t w = sqrt_modf(x,ff);
//        cout << "  w=" << w << "  == sqrt_mod(x,m)\n";
//        umod_t s = mul_mod(w,w,m);
////        cout << "  s=" << s << "\n";
//        jjassert( s==x );
//        x = w;
//    }
