
#include "mod.h"
#include "modm.h"
#include "jjassert.h"


umod_t
chinese(const umod_t *x, const factorization &f)
{
    int n = f.npr;

    // (omitted test that gcd(m_0,...,m_{n-1})=1 )

    umod_t mm = f.product();
//    cout << " mm=" << mm << endl;

    umod_t mi, mp, ti, xa, c = 0;
    for (int i=0; i<n; ++i)
    {
//        cout << " ----- \n";
//        cout << " x[" << i << "]=" << x[i] << endl;

        mi = f.factor(i);
//        cout << " mi=" << mi << endl;

        mp = mm/mi;
//        cout << " mp=" << mp << endl;

        ti = inv_mod(mp,mi);  // 0 <= ti < mi
//        cout << " ti=" << ti << endl;

        ti *= mp;                // 0 <= ti < mm
//        cout << " ti=" << ti << endl;

        xa = mul_mod(ti,x[i],mm);
//        cout << " xa=" << xa << endl;

        c = add_mod(c,xa,mm);
//        cout << " c[" << i << "]=" << c << endl;
    }

    return c;
}
//================= end CHINESE ================

