
#include <iostream.h>

#include "mtypes.h"
#include "jjassert.h"



static uint * primetab = NULL;
static uint ct;

uint
prime(uint n)
{
    if ( n>=ct )  return 0;
    else          return primetab[n];
}
// ====== end PRIME =====


uint
erastothenes(uint m)
{
    uint i,k;
    uint p[m];

    for (i=0; i<m; ++i)  p[i]=0;

    ct = 0;
    for (i=2; i<m; ++i)
    {
        if ( 0==p[i] )
        {
            ct++;
            for (k=2*i; k<m; k+=i)  p[k] = 1;
        }
    }

//    print_primes(p,m);

    if ( primetab )  delete [] primetab;

    primetab = new uint[ct+1];
    primetab[ct] = 0;

    k = 0;
    for (i=2; i<m; ++i)
    {
        if ( 0==p[i] )
        {
            primetab[k] = i;
            k++;
        }
    }
    jjassert( k==ct );

    return ct;
}
// ------------------------


/*
void
print_primes(int *p, int m)
{
    cout << "\n// this is a generated file, do not edit!";
    cout << "\n// (see makeprimes.cc)\n";
    cout << "\n// primes below " << m << "\n";

    cout << "\n// total " << ct << " primes \n";
    cout << "\nextern const unsigned int primetab[] =\n{\n";

    for (i=2; i<m; ++i)
    {
        if ( 1==(i%50) )  cout << "\n";

        if ( 0==p[i] )  cout << i << ", ";
    }

    cout << "\n0  // zero terminated\n};\n";
}
// ------------------------
*/
