#if !defined __MODFFT_H
#define      __MODFFT_H


#include "mod.h"

//mfftdit4:
void mod_fft_dit4(mod *f, ulong ldn, int is);

//mfftdif4:
void mod_fft_dif4(mod *f, ulong ldn, int is);


// fftdit2.cc:
void mod_fft_dit2(mod *f, ulong ldn, int is);

// fftdif2.cc:
void mod_fft_dif2(mod *f, ulong ldn, int is);

//// fftdif2nc.cc:
//void mod_fft_dif2_noncyclic(mod *f, ulong ldn, int is);

//// mcnvlnc.cc:
//void fft_mod_convolution_noncyclic(mod *f, mod *g, ulong ldn);
//void fft_mod_auto_convolution_noncyclic(mod *f, ulong ldn);

// mcnvl.cc:
void fft_mod_auto_convolution(mod *f, ulong ldn);
void fft_mod_convolution(mod *f, mod *g, ulong ldn);
void fft_mod_convolution(mod *f, mod *g, mod *h, ulong ldn);
void slow_mod_convolution(mod *f, mod *g, ulong n);
void slow_mod_convolution(double *f, double *g, ulong ldn);
void double_to_mod_by_force(double *f, ulong n);
void mod_to_double_by_force(mod *m, ulong n);
//
// for hfloat:
void fft_mod_convolution(double *f, double *g, ulong ldn);
void fft_mod_auto_convolution(double *f, ulong ldn);

// mslowcnvl.cc:
void slow_convolution(mod *f, mod *g, ulong nu);


// mfftwide.cc:
void wide_mod_fft(mod *f, ulong n, ulong d, mod *w, int is);
void wide_mod_fft0(mod *f, ulong n, ulong d, mod *w, int is);

// mfftndim.cc:
void mod_fft_ndim(mod *f, ulong ndim, ulong *ldn, int is);


// msft.cc:  (brute force (slow) mod ft)
void mod_sft(mod *f, ulong ldn, int is);


// mfftlearn.cc:  (learner's simple versions)
void mod_fft_dif2l(mod *f, ulong ldn, int is);
void mod_fft_dit2l(mod *f, ulong ldn, int is);


// mscramble.cc:
void scramble(mod *fr, ulong n);
void scramble0(mod *fr, ulong n);


// mfftaux.cc:
void sumdiff2(mod *f, ulong n);
ulong ld(ulong x);


#endif // !defined __MODFFT_H
