
#include "fxtaux.h"

ulong
graycode(ulong x)
{
    return x^(x>>1);
}


ulong
inverse_graycode(ulong x)
//
// inverse if graycode()
//
{
    ulong h = 1;
    ulong r = 0;

    do
    {
        if ( x&1 )  r^=h;

        x >>= 1;
        h = (h<<1)+1;
    }
    while( x!=0 );

    return r;
}



//#include <iostream.h>

void
gray_scramble(double *f, ulong n)
{
    double *r = new double [n];

    for (ulong m=0; m<n; ++m)
    {
        ulong g=graycode(m);

	r[g] = f[m];
    }

    d_copy(r,f,n);

    delete [] r;
}

/*
void
gray_scramble(double *f, ulong n)
{
    for (ulong m=n-1; m>0; --m)
    {
        ulong j=graycode(m);

        if ( j>m )  SWAP(f[m],f[j]);
	//	cerr<<" swap("<<m<<", "<<j<<")"<<endl;

    }
}


void
gray_scramble0(double *f, ulong n)
{
    for (ulong m=n/2-1; m>0; --m)
    {
        ulong j=graycode(m);

        if ( j<m )  SWAP(f[m],f[j]);
    }
}


void
gray_scramble_up(double *f, ulong n)
{
    for (ulong m=0; m<n; ++m)
    {
        ulong j=graycode(m);

        if ( j>m )  SWAP(f[m],f[j]);
    }
}
*/
