
#include <iostream.h>
#include <iomanip.h>
#include <assert.h>

#include "hfgutsfu.h"
#include "hfdata.h"



int 
gt_print(const char *what, const hfguts &a, ulong s, ulong e)
{
    return gt_save(cout,what,a,s,e);
}
//================== end GT_PRINT =============================


int 
gt_save(ostream &os, const char *what, const hfguts &a, ulong s, ulong e)
//
// print digits s...e
// e==0 => print all digits (default)
// negative n => print last n LIMBs
//
// return: 0 ==ok
//         -1==fail
{
    if ( 0==e )  e = a.prec();

    if ( e>a.prec() )  e = a.prec();

    assert( s<=e );


    LIMB *ad;
    ad=a.data()->dig();

    if ( os.fail() )
    {
        cerr<< "\n save(): FAILED ! "<<endl;
        return -1;
    }


    if ( what!=NULL )  os << what << flush; 

    if ( a.is_zero() )
    {
        os << "0.0";
    }
    else
    {
        if (a.sign()<0)  os << "-";
        else             os << "+";

        os << ".";

        int rxb = (hfdata::rxbase);

        if ( (0==s) && ( (10==rxb) || (16==rxb) ) )  // ---- nicer printing:
        {
            int    p = (hfdata::rxbspw);
            int    x = (hfdata::rx);
            LIMB   a0 = ad[0];

            int    z = -1;  // leading zeros
            while ( (a0<x) && (p--) )  // count leading zeros
            {
                x /= rxb;
                z++;
            }

            ulong  k = s;
            if (z)  // print nonzero digits of first LIMB
            {
                os << setbase(rxb) << ad[0];
                k++;
            }

            // print the LIMBS:
            os << setbase(rxb) << setfill('0');
            for ( ; k<e; ++k)
            {
                os << setw(hfdata::rxbspw) << ad[k] ;
            }

            // print exponent:
            os<< setbase(10) << setfill(' ');
            os<< "*" << rxb 
              << "^" << (long)((hfdata::rxbspw) * a.exp() - z);
        }
        else  // --------- simple LIMB printing:
        {
            // indicate how many LIMBs are left out:
            if ( 0!=s )  os << " <..." << s << "LIMBs+> ";

            // print the LIMBS:
            for (ulong k=s; k<e; ++k)
            {
                os.form(hfdata::rxfmt,ad[k]);
            }

            // indicate how many LIMBs are left out:
            if ( (0!=s) && (e!=a.prec()) )
            {
                os << " <+" << (a.prec()-e) << "LIMBs...> ";
            }

            // print exponent:
            if ( 0==s )
            {
                os<< setbase(10) << setfill(' ');
                os<< "*" << rxb
                  << "^" << (long)((hfdata::rxbspw) * a.exp());
            }
        }
    }

    os << endl;

    return 0;
}
//================== end GT_SAVE =============================
