
#include <math.h>

#include "hfloatfu.h"
#include "hfgutsfu.h"
#include "hfdatafu.h"
#include "mybuiltin.h"


long
cmp(const hfloat &a, const hfloat &b)
//
// return  0 if a=b
//        +1 if a>b
//        -1 if a<b
//
{
    return gt_cmp(*(a.guts()), *(b.guts()));
}
//================= end CMP =================


long
cmp1(const hfloat &a, ulong startdig) // =0
//
// return  0  if a=1
//        pos if a>1
//        neg if a<1
//
{
    return gt_cmp_one(*(a.guts()),startdig);
}
//=========================== end CMP1 ========================



long
cmp_limbs(const hfloat &a, const hfloat &b)
//
// returns the (signed) index of the first disagreeing LIMB:
// 0 is also returned if signs or exponents disagree
//
{
    if ( a.sign()!=b.sign() )  return 0;

    if ( a.exp()!=b.exp() )  return 0;  // problem for 1.000 and .999

    // ugly: skip guts layer
    return  dt_cmp(*a.guts()->data(), a.prec(), *b.guts()->data(), b.prec());
}
//=============== end CMP_LIMBS ====================


int
approximate(const hfloat &a, double d, double relerr)
//
// whether a==d within relative error relerr
// relerr defaults to 1e-12
//
// useful for checks
//
{
    double t;
    hfloat2d(a,t);

    if ( t==0 )  return (d==0);

    if ( SIGN(t)!=SIGN(d) )  return 0;

    t = fabs(t);
    d = fabs(d);

    double mi = MIN(t,d);
    double ma = MAX(t,d);

    double re = ((ma-mi)/ma);

    //    cout << " approximate(): re=" << re << endl;

    return (re<relerr);
}
//=================== end APPROXIMATE ========================
