
#include <math.h>

#include "hfloatfu.h"

//
// cosh, sinh, acosh, asinh LITTLE TESTED !
//


hfloat
log(const hfloat &h)
{
    hfloat h3;
    log(h,h3);
    return h3;
}
// -----------------


hfloat
exp(const hfloat &h)
{
    hfloat h3;
    exp(h,h3);
    return h3;
}
// -----------------


void
log(const hfloat &a, const hfloat &b, hfloat &c)
{
    hfloat t(c.prec());
    log(b,t);
    log(a,c);

    c /= t;
}
// ======== end LOG =========


void
log(const hfloat &a, hfloat &b)
//
// log(m*r^x) = log(m) + x*log(r)
//
{
    //    cout << "\n\n start LOG() \n";
    //    print("\n log(): arg=\n",a,12);
    assert( (a>(long)0) *(int)"negative arg for log()" );

    // --- log(mantissa):
    b = a;
    b.exp( 0 );  // remove exponent
    double  d;
    hfloat2d(b,d);
    long  r = (long)ceil(log(d)/log(0.5));
    //    cout << " r=" << r << endl;

    if ( r!=1 )  root(b,r,b);  // b^(-1/r)
    //    print("\n arg^(1/r)=\n",b,12);

    //    print("\n b=\n",b,12);
    log_agm(b,b);               // (-1/r)*log(b)

    if ( r!=1 )  b *= r;       // log(b)

    // --- exponent:
    long  x = a.exp();
    if ( x!=0 )
    {
        hfloat lr(b.prec());
        lr = constant_logrx(b.prec());
        lr *= x;
        b += lr;
    }
}
// ======== end LOG =========


void
acosh(const hfloat &a, hfloat &b)
{
    long  c1 = cmp1(a);

    if ( c1==0 )
    {
	b = 0;
    }
    else
    {
	if ( c1<0 )  assert( 0*(int)" acosh(x) for x<1 ");

	hfloat x(b.prec());
	x = a;

	sqr(a,b);
	b -= 1;
	sqrt(b,b);
	x += b;
	log(x,b);  // log(x+sqrt(x^2-1))
    }
}
// =========== end ACOSH ============


void
asinh(const hfloat &a, hfloat &b)
{
    hfloat x(b.prec());
    x = a;

    sqr(a,b);
    b += 1;
    sqrt(b,b);
    x += b;
    log(x,b);  // log(x+sqrt(x^2+1))
}
// =========== end ASINH ============




void
exp(const hfloat &a, hfloat &b, ulong startprec)
//
// startprec defaults to 0
//
{
    if( same_mantissa(a,b) )
    {
        hfloat x(b.prec());
        copy(a,x);
        exp_iteration(x,b,startprec);
    }
    else
    {
        exp_iteration(a,b,startprec);
    }
}
// =========== end EXP ============


void
cosh(const hfloat &a, hfloat &b)
{
    exp(a,b);

    hfloat x(b.prec());
    inv(b,x);
    b += x;
    b /= 2;
}
// =========== end COSH ============


void
sinh(const hfloat &a, hfloat &b)
{
    exp(a,b);

    hfloat x(b.prec());
    inv(b,x);
    b -= x;
    b /= 2;
}
// =========== end SINH ============
