\section{Grundlegende Implementierungsrichtlinien}
%=================================================

Im folgenden stellen wir sieben Richtlinien zur Implementierung einer Arithmetik vor, auf denen die
\Piologie-Bibliothek beruht.
\begin{description}
\item[1. Effizienz.]\label{Effizienz}
Die Effizienz der Algorithmen in Theorie und Praxis ist die grundlegende Forderung an diese Arbeit.

\item[2. Implementierung.]\label{Implementierung}
Bei der Implementierung mu"s der ANSI-\cpp\ Standard eingehalten werden, um Portabilit"at f"ur
jedes System, das sich auch an den Standard h"alt, gew"ahren zu k"onnen. Daher sollten integrierte Assembler-Sequenzen
prinzipiell vermieden werden und in zeitkritischen Situationen eine konkrete Analyse "uber den dadurch m"oglichen
Zeitgewinn erfolgen, um zu entscheiden, ob "uberhaupt Assembler in Betracht gezogen werden kann.

\item[3. Einschr"ankungsfrei.]\label{Einschraenkungsfrei}
Die Bibliothek sollte so geschrieben sein, da"s sie ohne "Anderungen in den Quell-Codes auf jedem Rechnersystem,
welches einen ANSI-\cpp\ Compiler besitzt, compiliert und dort ausgef"uhrt werden kann. Daher mu"s alles verkapselt
programmiert sein, das hei"st es d"urfen keine globalen Variablen verwendet werden, und selbst globale Konstanten sollten
sich selber einstellen k"onnen. Die voreingestellten Konstanten d"urfen h"ochstens ein Geschwindigkeitsdefizit mit sich
bringen, aber auf keinen Fall die Benutzung einschr"anken. Aus diesem Grund darf zum Beispiel eine Konstante
\texttt{MAXARRAY}, die die feste Allokationsgr"o"se in vielen Arithmetikimplementationen angibt und so die maximal
m"oglichen Stellen einschr"ankt, nicht verwendet werden, denn damit w"are das "Uberlaufproblem lediglich auf eine h"ohere
Ebene verschoben und keineswegs gel"ost.

\item[4. Benutzerforderungen.]\label{Benutzerforderungen}
Es ist eine stabile Schnittstelle zum Anwender hin notwendig, weil dem Benutzer nicht vorgeschrieben werden darf,
unter welchen Bedingungen, in welcher Umgebung und mit welchen Argumenten er die Funktion aufruft.
Genausowenig sollte er mit dem verbindlichen Aufrufen von Konstruktoren und Destruktoren unn"otig beansprucht werden.

\item[5. Einheitlichkeit.]\label{Einheitlichkeit}
Aus Stabilit"ats- und Effizienzgr"unden darf es nur einen einzigen Grunddatentyp f"ur alle elementaren
arithmetischen Operationen geben; es soll also kein gr"o"serer Datentyp als Auffangbecken f"ur die bei diesen Operationen
entstandenen "Ubertr"age beziehungsweise "Uberl"aufe verwendet werden. Dieser Grunddatentyp mu"s komplett ausgenutzt
werden, wobei die Basis f"ur die Zahlendarstellung vom Computer und dem gew"ahlten Datentyp abh"angt.

\item[6. Selbsterkl"arend.]\label{Selbsterklaerend}
Die Arithmetik sollte weitgehend durch sich selbst erkl"arend sein, weswegen es zum Beispiel auf jeden Fall
"uberladene Operatoren geben mu"s. Diese Operatoren sollten so effizient implementiert sein,
da"s sie Funktionen f"ur arithmetische Operationen "uberfl"ussig machen. Das "Uberladen der Operatoren hat einen so hohen
Stellenwert, da"s es den alten Standard wie "'\texttt{iadd}"{} f"ur die Addition ganzer Zahlen beziehungsweise
"'\texttt{radd}"{} f"ur die Addition rationaler Zahlen ersetzen soll. Sp"atestens n"amlich, wenn wir Kombinationen bilden
wollen, werden die Ausdr"ucke sonst unflexibel und ufern aus, wie etwa "'\texttt{rpadd}"{} f"ur die Polynomaddition "uber den
rationalen Zahlen oder "'\texttt{ipadd}"{} f"ur die Polynomaddition "uber den ganzen Zahlen. Und das Spiel geht endlos
weiter, wenn wir Polynome "uber Matrizen und Matrizen mit Polynomeintr"agen und so fort betrachen, die beispielsweise
bei der L"osung von gew"ohnlichen Differentialgleichungen entstehen k"onnen.\\
Dar"uberhinaus sind Operatoren intuitiv standardisiert und verlangen deshalb nicht notwendig eine Spezifikation der
Argument"ubergabe.\\
Der Anwender sollte also nur mit den Sprachelementen vertraut sein m"ussen, die zur L"osung seiner Probleme unbedingt
erforderlich sind.

\item[7. Progressivit"at.]\label{Progressivitaet}
Von gro"ser Bedeutung sind die neueren Features der Programmiersprache \cpp, die durch die STL (siehe \cite{MuSa96})
unumg"anglich geworden sind. Durch die Verwendung dieser neuen Sprachmittel k"onnen oft nur aktuelle
Compiler mithalten, wodurch die Portabilit"at einer Bibliothek gef"ahrdet ist. In diesem Punkt werden wir unsere
einzige Einschr"ankung machen und Compiler mit der STL voraussetzen, um eine Bibliothek zu haben, die (zumindest bis zur
endg"ultigen Festlegung des Standards) auf neuestem Stand ist.
\end{description}

Nun gilt es zu untersuchen, ob eine Implementierung m"oglich ist, die all diesen Forderungen gerecht wird.



\section{Zahlenhierarchie/-systeme}
%==================================

\begin{center}
\begin{picture}(90,100)\thicklines
\put(60,80){\makebox(0,0){\fbox{\NumberBase}}}
\put(60,50){\makebox(0,0){\fbox{\Natural}}}
\put(60,57.5){\vector(0,1){15}}
\put(60,20){\makebox(0,0){\fbox{\Integer}}}
\put(60,27.5){\vector(0,1){15}}

\put(10,20){\makebox(0,0){\fbox{\Fixed}}}
\put(20,27.5){\vector(1,1){20}}
\end{picture}
\end{center}


\subsection{Verwaltung der Arithmetik}
%-------------------------------------

In \NumberBase\ ist die grundlegende Verwaltung der Arithmetik verankert, unter anderem die \Digit operationen und
die Fehlerbehandlung:

@O digit.h
@{///////////////////////////////
//
// Piologie V1.2.1
// multi-precision arithmetic
// Digit / NumberBase
//
// Sebastian Wedeniwski
// 03/18/1998
//

#ifndef _Include_Digit_H_
#define _Include_Digit_H_

@<included files of the file \texttt{"{}digit.h"{}}@>
@<type declaration of \Digit\@>
@<macro definitions of the file \texttt{"{}digit.h"{}}@>
@<declarations of error-handling@>
@<function prototypes of the file \texttt{"{}digit.h"{}}@>
@<constants of \Piologie\@>
@<class prototype of \NumberBase\@>
@<inline implementation of the file \texttt{"{}digit.h"{}}@>

#endif
@}


\subsection{Implementationskonstanten}
%-------------------------------------

Unser Basisdatentyp \Digit\index{\Digit} ist ein elementarer vorzeichenloser Typ, der mit den elementaren Speichereinheiten
eines Rechners und Grundoperationen korrespondiert. In der Regel wird hierf"ur der elementare Typ
\texttt{unsigned int} oder \texttt{unsigned long} eingesetzt:\label{Digit}
@d type declaration of \Digit\
@{typedef unsigned long Digit;
@}
% //#if (defined (__i386__) || defined (__i486__)) && defined (__GNUC__)
% //typedef unsigned long long Digit;
% //#elif _M_IX86 >= 300 && _MSC_VER || defined(__386__) && defined(__WATCOMC__)
% //typedef unsigned __int64 Digit;
% //#else

Wenn man allerdings den GNU-\cpp\-Compiler verwendet, dann ist auch der Typ \texttt{unsigned long long int}
m"oglich, der genau die doppelte Datenl"ange von \texttt{long int} hat.\\
Durch die Wahl des Basisdatentyps \Digit\ steht gleichzeitig die erste wichtige Konstante $\beta$
\index{{$\beta$}}\index{\texttt{BETA}}
fest, die die Anzahl der Bits angibt:\label{BETA}

@d constant $\beta$
@{const size_t BETA        = sizeof(Digit)*CHAR_BIT;
@}

wobei \verb|CHAR_BIT| die Anzahl der Bits pro Byte angibt, und zwar in der Standard-Headerdatei:

@d standard system include file \texttt{<limits.h>}
@{#include <limits.h>
@}

Eine weitere Konstante $\gamma$\index{{$\gamma$}}\index{\texttt{GAMMA}}
repr"asentiert unsere maximal m"ogliche Zahl in \Digit, das hei"st\label{GAMMA}

@d constant $\gamma$
@{const Digit  GAMMA       = ~Digit(0);                 // 2^BETA - 1
@}

Um nicht bei jedem internen "Uberlauf die Langzahl um nur einen \Digit\ zu erweitern, f"uhren wir die Konstante
$\delta$ ein, um die die Langzahl erweitert wird.

@d constant $\delta$
@{const size_t DELTA       = 8;                         // >= 2!
@}

Zur Konvertierung in das Dezimalsystem ben"otigen wir noch die Konstante \index{{$\alpha$}}\index{\texttt{ALPHA}}
\index{\verb#ALPHA_WIDTH#}\label{ALPHA}
$\alpha := 10^{\lfloor\log_{10}(2^\beta)\rfloor}$, die die gr"o"ste m"ogliche Zehnerpotenz in \Digit\ darstellt:

@d constant $\alpha$
@{const size_t ALPHA_WIDTH = size_t(0.301029995664*BETA);
const Digit  ALPHA       = pow10(ALPHA_WIDTH);
@}

Die L"ange unseres \Natural s wird durch den Typ \Size\index{\Size} aus der Standard-Headerdatei\label{Size}
@d standard system include file \texttt{<stdlib.h>}
@{#include <stdlib.h>
@}
repr"asentiert, der folgenderma"sen belegt ist:\\
Sei $x\in\Natural\subset\N$, dann gilt f"ur die L"ange von $x$\label{Length}

\[\Length(x) := \left\{\begin{array}{r@@{\;,\quad}l}
\lfloor\log_{2^\beta}x\rfloor + 1 & x > 0\\
1 & x = 0
\end{array}\right..\]


\subsection{Die Klasse \NumberBase\ und grundlegende Notationen aus \cpp}
%-----------------------------------------------------------------------

Alle Implementierungen erfolgen ausschlie"slich in \cpp. An dieser Stelle ist zwar keine Einf"uhrung in \cpp\ vorgesehen,
aber eine knappe Erl"auterung einiger grundlegender Begriffe und Vorgehensweisen am Beispiel der Klasse
\NumberBase. Zum besseren Verst"andnis des folgenden ist eine Einf"uhrung in \cpp\ wie zum Beispiel mit den Werken
von B. Stroustrup \cite{Str97} und S. B. Lippman \cite{Lip95} empfehlenswert.


\subsubsection{Einige Schl"usselw"orter}

Eine \textbf{Klasse} \index{Klasse} ist eine grundlegende Struktur, die sowohl Daten als auch Funktionen zusammenfa"st
und sie als gleichwertige Elemente enth"alt. Diese Elemente werden in drei Zugangsebenen aufgeteilt:
\begin{enumerate}
\item Auf die privat deklarierten Elemente im \textbf{private}-Abschnitt\index{\texttt{private}} k"onnen nur Elemente
derselben Klasse zugreifen, weshalb ein Zugriff von "'au"sen"{} nicht m"oglich ist.
\item Die im \textbf{protected}-Abschnitt\index{\texttt{protected}} gesch"utzten Elemente k"onnen dagegen nicht nur von
der eigenen Klasse, sondern auch von den abgeleiteten Klassen erreicht werden.
\item Die "offentlichen Elemente schlie"slich sind im \textbf{public}-Abschnitt allgemein zug"anglich.\index{\texttt{public}}
\end{enumerate}
Damit k"onnen wir nun Strukturen erzeugen, in denen ein Anwender nur gewisse Zugangsrechte erteilt bekommt.\\

Bei einer Anweisung wie \verb|NumberBase x| wird Speicherplatz f"ur die Variable \texttt{x} (unser
erzeugtes \index{Objekt}\textbf{Objekt}) reserviert, das auch als \textbf{Instanz}\index{Instanz} der Klasse \NumberBase\
bezeichnet wird.\\

Das Schl"usselwort \texttt{inline}\index{\texttt{inline}} vor der Funktionsdefinition bedeutet ein direktes Einsetzen ins
Programm, "ahnlich einer textuellen Ersetzung eines Makros mit zus"atzlicher Typ"uberpr"ufung und bedingungsloser
Argument"ubergabe.
Der Vorteil besteht darin, da"s keine Spr"unge mehr in die Funktion hinein auftreten, wie zum Beispiel beim Vertauschen
zweier \Digit s:

@d the function swap for \Digit s
@{inline void swap(Digit& a, Digit& b)
// Algorithm:  swap(a, b)
//             Let t in Digit.
// Input:      a,b in Digit.
// Output:     a,b in Digit such that t := a, a := b, b := t ||
{
  Digit t = a; a = b; b = t;
}
@| swap @}

\texttt{inline}-Funktionen sind aber nur f"ur kleine und schnelle Funktionen sinnvoll, um Effizienzeinbu"sen bei
den relativ zeitaufwendigen Funktionsaufrufen einzusparen; gleichzeitig gew"ahrt man hiermit dem Compiler bessere
Optimierungsm"oglichkeiten. Bei Funktionen, die einen gr"o"seren Rechenaufwand ben"otigen,
ist der Zeitgewinn durch eine \texttt{inline}-Funktion "uberhaupt nicht me"sbar und daher auch nicht notwendig:\\

\small\begin{minipage}{\linewidth}
\begin{verbatim}
inline void copy(Digit* to, Digit* from)
{
  for (size_t sz = 1000; sz; --sz) *to++ = *from++;
}
\end{verbatim}
\end{minipage}\normalsize\\[3ex]

Hier ist die Laufzeit f"ur die Schleifendurchl"aufe sogar um ein Vielfaches h"oher als ein einzelner Sprungbefehl.\\
\texttt{inline}-Funktionen k"onnen auch geschickt zur Vermeidung der \texttt{goto}-Anweisung \index{\texttt{goto}}
eingesetzt werden:
\small
%\begin{minipage}{\linewidth}
\begin{verbatim}
inline bool found(const int z, const int* x, const int n, const int m)
{
  for (int i = 0; i < n; ++i)
    for (int j = 0; j < m; ++j)
      if (x[i][j] == z) return true;
  return false;
}

void search(const int z, const int* x, const int n, const int m)
{
  if (found(z, x, n, m)) //...
  else //...
}
\end{verbatim}
%\end{minipage}
\normalsize


\subsubsection{Konstruktor/Destruktor}

Eine Elementfunktion, die den gleichen Namen wie die Klasse selbst tr"agt, ist ein \textbf{Konstruktor}.
\index{Konstruktor}
Diese Funktion wird jedesmal aufgerufen, wenn ein neues Objekt angelegt werden soll. Um dieses Objekt wieder zu
entfernen, dient das Gegenst"uck zum Konstruktor, der \textbf{Destruktor}.\index{Destruktor}
Dieser wird mit dem Namen der Klasse und einer vorangestellten Tilde (\verb|~|) bezeichnet.
Konstruktoren und Funktionen k"onnen auch \textbf{"uberladen}\index{\"Uberladen von Funktionen} werden. Das bedeutet,
da"s mehrere Funktionen denselben Namen zugewiesen bekommen k"onnen, wobei sie sich aber in den Argumenten unterscheiden
m"ussen. Jede Klasse besitzt aber nur eine Destruktor-Funktion, die argumentlos ist. Dieser Destruktor wird automatisch f"ur
jedes Objekt aufgerufen, wenn sein definierter \textbf{G"ultigkeitsbereich}\index{G\"ultigkeitsbereich} verlassen wird.


\subsubsection{Die Klasse \NumberBase}

Die Deklaration unserer Klasse hat die folgende Gestalt:

@D class prototype of \NumberBase\
@{class NumberBase {
@<static variable declarations of \NumberBase\@>
  NumberBase();                               // default constructor
  ~NumberBase();                              // destructor

  @<protected function prototypes@>
public:
  @<function prototypes for \Digit operations in \NumberBase\@>

  void   errmsg(const int, const char*) const;
  @<function prototypes for prime numbers in \NumberBase\@>
};
@| NumberBase @}

Weitere Konstruktoren werden wir beim Betrachten der Klasse \Natural\ im Kapitel \ref{Natural-Konstruktoren} auf der
Seite \pageref{Natural-Konstruktoren} kennenlernen.



\section{Korrekte Software}
%==========================

Wir verwenden mehrere Diagnosemakros, die die Aufgabe haben, die Sicherheit w"ahrend und nach dem Abschlu"s der
Bibliotheksentwicklung zu testen. Durch Diagnoseroutinen im Quelltext lassen sich dabei Fehler einfacher erkennen,
lokalisieren und beheben. Als Grundlage f"ur die folgenden Makros

@D macro definitions for internal conditions
@{#ifdef _Piologie_Debug_
# define CONDITION(expr)     assert(expr)

@<condition of a \Natural\@>
@<condition of an \Integer\@>
#else
# define CONDITION(__ignore)        ((void)0)
# define NATURALCONDITION(__ignore) ((void)0)
# define INTEGERCONDITION(__ignore) ((void)0)
# define NATURAL_FOR_CHECK(__ignore1, __ignore2) ((void)0)
# define INTEGER_FOR_CHECK(__ignore1, __ignore2) ((void)0)
#endif
@| CONDITION NATURALCONDITION INTEGERCONDITION NATURAL_FOR_CHECK INTEGER_FOR_CHECK @}

dient die ANSI-Funktion \texttt{assert}, die eine Bedingung pr"uft und das Programm abbricht, wenn sie nicht zutrifft.
Aus Effizienzgr"unden wird die Indirektion \verb!_Piologie_Debug_! eingef"uhrt, um die zus"atzlichen "Uberpr"ufungen im
Quelltext gegebenenfalls abschalten zu k"onnen.




\section{Ordnung}
%================

\textbf{Definition.} Sei $f : \N^k\to\R$ eine Funktion f"ur $k\in\N$, dann ist\label{Ordnung}
\[\Ord(f) := \{g : \Image(f)\to\R\mid\exists_{a,b\in\R_{>0}}\forall_{x\in\Image(f)}: a|g(x)|\leq|f(x)|\leq b|g(x)|\}\]
die \textbf{"Aquivalenzklasse}\index{\"Aquivalenzklasse}
von $f$. Dadurch sind zwei Funktionen $f,g : \N^k\to\R$ zueinander \textbf{"aquivalent}\index{\"aquivalent}
($f\sim g$), falls $f\in\Ord(g)$ gilt. Alle Funktionen dieser Klasse ben"otigen also -- mit Ausnahme einer Konstante --
denselben zeitlichen Aufwand. Dabei nennt man $\Ord(f)$ auch die \textbf{Ordnung}\index{Ordnung} von $f$.\\
Der Einfachheit halber schreiben wir ab jetzt $\Ord(\Image(f))$ statt $\Ord(f)$.\\

\textbf{Beispiel} (Multiplikation zweier \Natural s).
Rekursiv betrachtet, sah lange Zeit die konventionelle Methode, zwei \Natural s miteinander zu multiplizieren,
folgenderma"sen aus:\bigskip\\
\begin{minipage}{\linewidth}
Seien $x,y\in\Natural$ mit $\Length(x) = \Length(y) = n$, so gilt\smallskip\\
$x\cdot y = 2^{2m\beta}x_1y_1 + 2^{m\beta}(x_1y_0 + x_0y_1) + x_0y_0$\\
mit $m := \lfloor n/2\rfloor, x := 2^{m\beta}x_1 + x_0$ und $y := 2^{m\beta}y_1 + y_0$.
\end{minipage}\bigskip\\
A. Karatsuba jedoch konnte die Anzahl der notwendigen Operationen von $\Ord(n^2)$ auf $\Ord(n^{\log_2(3)})$
reduzieren\footnote{Eine genaue Analyse findet man im Kapitel \ref{Karatsuba-Operationen} auf der Seite
\pageref{Karatsuba-Operationen}.}, indem er die folgende Rekursion aufstellte:
\[a := x_1y_1, b := (x_1 - x_0)(y_0 - y_1), c := x_0y_0
\mbox{ und somit } xy = 2^{2m\beta}a + 2^{m\beta}(b + a + c) + c.\]
Genaugenommen m"u"sten wir
\[\mathtt{mul}\in\Ord((\Length(x),\Length(y))\mapsto\Length(x)\cdot\Length(y)) = \Ord(\Length(x)\cdot\Length(y))\]
mit $\mathtt{mul}:\Natural^2\to\Natural:(x,y)\mapsto x\cdot y$
f"ur die konventionelle Multiplikation zweier Zahlen schreiben.
Man w"ahlt jedoch oft der Einfachheit und "Ubersichtlichkeit wegen einen m"oglichst einfachen
\textbf{Repr"asentanten}\index{Repr\"asentanten}, zum Beispiel $\mathtt{mul}\in\Ord(n^2)$, wenn es nicht so sehr auf die
genaue Anzahl der Operationen ankommt.



\section{Programmtechnische Optimierungsrichtlinien}
%===================================================

In diesem Abschnitt sind zwei Richtlinien von besonderem Interesse:
\begin{description}
\item[1. Klare Struktur.]
Ein wichtiger Punkt ist die klare Struktur und elegante Integrierung der Algorithmen. Daher d"urfen die l"angst
"uberholten \index{\texttt{goto}-Anweisung}\texttt{goto}-Anweisungen\footnote{Diese sind eher rudiment"are
Sprachelemente aus C-Zeiten als "ubersichtliche Strukturhilfen.}
nicht mehr verwendet werden und sollten die Sprachelemente \texttt{break} und \texttt{continue} m"oglichst vermieden
werden. Bei \texttt{for}-Konstruktionen kann man geteilter Meinung sein, wie das folgende Beispiel zeigt, das in
Bezug auf die Code-Generierung in beiden F"allen "aquivalent ist:\\

\index{\texttt{break}-Anweisung}
\small \begin{minipage}{\linewidth}
\begin{tabbing}
\verb|for (i = 0; i < j; ++i)|  \`{\itshape // mit \verb|break|-Anweisung}\\
\verb|  if (i == k) break;|\\
\\
\verb|for (i = 0; i < j && i != k; ++i);| \`{\itshape // ohne \verb|break|-Anweisung}
\end{tabbing}
\end{minipage} \normalsize\\[3ex]
Hierbei kann es dem Programmierer "uberlassen bleiben, welche Konstruktion f"ur ihn ansprechender ist und er lieber
verwenden m"ochte. Wir werden jedoch bei der Implementierung der Langzahlbibliothek die zweite Variante (ohne
\texttt{break}-Anweisung) bevorzugen.\\


\item[2. Schleifen aufrollen und komprimieren.]\index{Aufrollen von Schleifen}
Unser Anliegen besteht nicht darin, das Programm durch aufrollen und komprimieren von Schleifen mit aller Gewalt zu
optimieren, was meist n"amlich nur zu un"ubersichtlichen Befehlsfolgen f"uhrt, wie zum Beispiel bei
dieser "'kompakten"{} Primzahlermittlung:\index{Algorithmus!komprimiert}\index{Primzahlenermittlung}
\small\begin{verbatim}
void primes(int n){for(int a=n;--a;n%a?a:--a?a=--n:printf("%d,",n));}
\end{verbatim}\normalsize
Warum sollte jemand so etwas schreiben? F"ur einen Blumentopf?\\

\textbf{Bemerkung.} Weitaus effizienter und "ubersichtlicher arbeiten die Siebalgorithmen, die wir sp"ater im
Kapitel \ref{Siebalgorithmen} noch betrachten werden.\\

"Ahnliches liegt auch bei folgendem "'aufgerollten"{} Algorithmus vor:\index{Algorithmus!aufgerollt}\index{\texttt{send}} % \\

\small%\begin{minipage}{\linewidth}
\begin{tabbing}
\verb|void send(register* to, register* from, register count)|\\
\itshape // Duff's Device. Hilfreiche Kommentare wurden bewu"st entfernt.\\
\verb|{|\\
\verb|  register n = (count+7)/8;|\\
\verb|  switch (count%8) {|\\
\verb|    case 0: do { *to++ = *from++;|\\
\verb|    case 7:      *to++ = *from++;|\\
\verb|    case 6:      *to++ = *from++;|\\
\verb|    case 5:      *to++ = *from++;|\\
\verb|    case 4:      *to++ = *from++;|\\
\verb|    case 3:      *to++ = *from++;|\\
\verb|    case 2:      *to++ = *from++;|\\
\verb|    case 1:      *to++ = *from++;|\\
\verb|               } while (--n > 0);|\\
\verb|  }|\\
\verb|}|
\end{tabbing}
%\end{minipage}
\normalsize% \\[3ex]
Dasselbe Ergebnis kann n"amlich auch anders erzielt werden, wie die drei n"achsten Varianten zeigen:
\index{\texttt{memcpy}}
\index{\texttt{memcopy}}
\index{\texttt{copy}}
\small\begin{verbatim}
inline void copy(Digit* result, const Digit* first, const size_t count)
{
  for (const Digit* last = first+count; first != last; ++first, ++result)
    *result = *first;
}

inline void copy2(Digit* result, const Digit* first, size_t count)
{
  while (count) {
    --count;
    result[count] = first[count];
  }
}

inline void memcopy(Digit* to, const Digit* from, size_t count)
{
  memcpy(to, from, count*sizeof(Digit));
}
\end{verbatim}\normalsize
Alle vier Versionen sind zwar etwa gleich schnell\footnote{Die Laufzeiten sind mit der Funktion \texttt{copy} als
Basisgr"o"se prozentual ermittelt, das hei"st, da"s zum Beispiel beim UltraSPARC die Funktion \texttt{copy2} um
52,1\% langsamer ist und die \texttt{memcopy} Funktion nur 38,3\% der von \texttt{copy} ben"otigten Zeit braucht.},\\

\mbox{}\hfill\small\begin{tabular}{l|r|r|r|r}
Prozessor/ & \texttt{copy} & \texttt{copy2} & \texttt{memcopy} & \texttt{send}\\
Compiler & (Basis) &&&\\
\hline\hline
Pentium: &&&&\\
Watcom \cpp\ 10.6 & 100\% & 97,8\% & 99,7\% & 99,7\%\\
Visual \cpp\ 4.0  & 100\% & 87,2\% & 88,9\% & 100\%\\
Borland \cpp\ 5.0 & 100\% & 87,3\% & 87,4\% & 87,3\%\\
\hline
GNU-C 2.7.2: &&&&\\
Pentium & 100\% & 100\% & 99,1\% & 98,6\%\\
80486 & 100\% & 98,6\% & 97,8\% & 98,6\%\\
SPARCstation10 & 100\% & 100,9\% & 99,4\% & 92,3\%\\
UltraSPARC & 100\% & 152,1\% & 38,3\% & 100,0\%\\
IBM Power PC & 100\% & 105,2\% & 85,7\% & 90,5\%\\
HP PA 7100 & 100\% & 104,9\% & 99,4\% & 99,6\%\\
\hline
Silicon Graphics \cpp\ 5.3: &&&&\\
MIPS R4000 & 100\% & 132,7\% & 74,9\% & 120,1\%\\
\hline
DEC \cpp: &&&&\\
DEC Alpha & 100\% & 98,8\% & 86,7\% & 98,8\%
\end{tabular}\normalsize\hfill\mbox{}\\

aber erstens ist der \texttt{send}-Code ungef"ahr um einen Faktor f"unf umfangreicher als die drei anderen L"osungen,\\

\mbox{}\hfill\small\begin{tabular}{l|c|c|c|c}
Prozessor/ & \texttt{copy} & \texttt{copy2} & \texttt{memcopy} & \texttt{send}\\
Compiler &&&&\\
\hline
Pentium: &&&&\\
Watcom \cpp\ 10.6 & 39 Bytes & 39 Bytes & 33 Bytes & 153 Bytes\\
Visual \cpp\ 4.0  & 36 Bytes & 40 Bytes & 25 Bytes & 249 Bytes
\end{tabular}\normalsize\hfill\mbox{}\\

und zweitens scheidet eine solche typenlose Daten"ubergabe aus Sicherheitsgr"unden f"ur
uns aus. Um die drei k"urzeren Varianten voneinander abzugrenzen, seien die folgenden Gedanken erw"ahnt:
Bei dieser Arithmetik mu"s man bedenken, da"s sich der Einsatz der Kopierfunktion meist auf wenige Ziffern beschr"ankt,
weshalb sich zur Steigerung der Effizienz eigentlich ein \texttt{inline} anbietet. Bei den meisten Compilern ist auch die
ANSI-Funktion \texttt{memcpy} als \texttt{inline} gel"ost und bietet in der Regel die optimalen Prozessoranweisungen,
doch ist ihr Verhalten bei "Uberlappung undefiniert. Damit ist diese Funktion f"ur eine unserer h"aufigsten T"atigkeiten,
die interne Datenverschiebung, in der Regel nicht zu gebrauchen.
Welche der beiden Funktionen \texttt{copy} und \texttt{copy2} nun schneller ist, h"angt haupts"achlich vom verwendeten
Prozessor ab.\\
Wir werden bei der Implementierung der Algorithmen "uberwiegend die zeigerorientierte \texttt{copy}-Funktion vorziehen und
der "Ubersichtlichkeit wegen, die folgenden sechs Makros zur Speicherverarbeitung verwenden:

@D macro definitions for internal memory manipulations
@{#define FILL_ZERO(a, b)                                 \
  do *a++ = 0; while (a != b)

#define FILL_DELTA(a)                                   \
  a[0] = a[1] = a[2] = a[3] = a[4] = a[5] = a[6] = a[7] = 0;

#define COPY(a, b, c, d)                                \
  do *a++ = *b++; while (c != d);

#define COPY_BACKWARD(a, b, c, d)                       \
  do *--a = *--b; while (c != d);

#define MOVE(a, b, c, d)                                \
  do { *a++ = *b; *b++ = 0; } while (c != d);

#define MOVE_BACKWARD(a, b, c, d)                       \
  do { *--a = *--b; *b = 0; } while (c != d);
@| FILL_ZERO FILL_DELTA COPY COPY_BACKWARD MOVE MOVE_BACKWARD @}

\end{description}



\section{Additionsalgorithmus}
%=============================

In diesem Abschnitt werden wir aus zwei Gr"unden einen neuen Additionsalgorithmus entwerfen:
\begin{enumerate}
\item Es ist sinnvoll, einen einzigen Grunddatentyp f"ur alle elementaren arithmetischen Operationen zu verwenden, der
vollst"andig ausgenutzt wird (siehe Kapitel \ref{Einheitlichkeit}).
\item Assembler-Sequenzen k"onnen mit wenigen Ausnahmen ohne Laufzeiteinbu"sen vermieden werden.
\end{enumerate}


\subsection{Ans"atze}
%--------------------

\subsubsection{Dezimaler Additionsalgorithmus}

A. Binstock und J. Rex f"uhren in \cite{BinRex95} auf Seite 422 einen dezimalen Ansatz f"ur einen
Additionsalgorithmus ein:\\

\index{Additionsalgorithmus!dezimal}
\small \begin{minipage}{\linewidth}
\begin{verbatim}
for (int i = start; i >= stop; i--) {
  sum->term[i] += t1->term[i] + t2->term[i];
  if (sum->term[i] > 9) {
    sum->term[i] -= 10;
    sum->term[i-1] += 1;
  }
}
\end{verbatim}
\end{minipage} \normalsize\\[3ex]
Wir werden in den n"achsten Abschnitten noch sehen, da"s wir durch diese Darstellung sehr viel Rechenzeit verschenken,
auch wenn wir als Basis die gr"o"stm"ogliche Zehnerpotzenz w"ahlen.


\subsubsection{Additionsalgorithmus "uber Bytes}

W. H. Press, S. A. Teukolsky, W. T. Vetterling und B. P. Flannery nutzen mit ihrem Ansatz in \cite{Pres92} auf Seite 916
zwar ein komplettes Byte aus, benutzen jedoch f"ur die elementaren Operationen zwei verschiedene Maschinentypen, und das,
um lediglich eine "uberlaufende Eins im h"oheren Datenbereich abzufangen. Da aber auf den heutigen Maschinen eine
32-Bit-Addition -- genauso wie die 8-Bit-Addition\footnote{Genaugenommen darf man im allgemeinem nicht davon ausgehen,
da"s der Maschinentyp \texttt{char} aus 8 Bit besteht.} -- nur einen Taktzyklus in Anspruch nimmt, ist hier mindestens ein
Faktor vier geopfert worden.\\

\index{Additionsalgorithmus!\"uber Bytes}
\small \begin{minipage}{\linewidth}
\begin{verbatim}
unsigned short ireg = 0;
for (int j = n; j >= 1; j--) {
  ireg = u[j] + v[j] + (unsigned char)(ireg & 0xff);
  w[j+1] = (unsigned char)(ireg >> 8 & 0xff);
}
w[1] = (unsigned char)(ireg >> 8 & 0xff);
\end{verbatim}
\end{minipage} \normalsize\\[3ex]
(Trotzdem ist dieser Ansatz recht effizient im Hinblick auf die Assembler-Code-Erzeugung. Die Maschinenunabh"angigkeit
wird dadurch erzielt, da"s die Relation
\[\texttt{sizeof(char)}\leq2\cdot\texttt{sizeof(short)}\]
f"ur die internen Maschinentypen vom ANSI-Komitee festgelegt wurde.)



\subsection{Additionsalgorithmus, der die vorgegeben Kriterien erf"ullt}
%-----------------------------------------------------------------------

Um uns an die ANSI-Festlegungen zu halten, d"urfen wir bei der Addition keinen Zugriff auf die Maschinen-Flags vornehmen,
was die Implementierung erheblich erschwert. Also m"ussen wir f"ur den "Ubertrag zuersteinmal ein Register verwenden.\\
Eine effiziente M"oglichkeit wird durch die folgende Gleichung realisiert:\index{Additionsalgorithmus!\"Ubertrag}\\

\begin{minipage}{\linewidth}
Seien $a,b\in\Digit$, so gilt\qquad $a + b = c\cdot2^\beta + d$
mit $a+b\equiv d\pmod{2^\beta}\mbox{ und } c = \left\{\begin{array}{r@@{\;,\quad}l}
1 & d < a\\
0 & d\geq a
\end{array}\right.$,
\end{minipage}\\[3ex]
was in ANSI-\cpp\ die folgende Gestalt hat:\\

\small \begin{minipage}{\linewidth}
\begin{verbatim}
  Digit d = a+b;
  Digit c = (d < a);
\end{verbatim}
\end{minipage} \normalsize\\[3ex]
weil \verb|(d < a)|$\in\{0,1\}\subseteq\mathtt{int}$ gilt.\\

Mit dieser Vor"uberlegung zur Ermittlung des "Ubertrages werden wir unseren Additionsalgorithmus in zwei Bereiche
aufteilen: Einen zur "uberlaufsfreien Addition und einen zur Addition inklusive Inkrementierung.\\
Diese beiden Bereiche sind stellvertretend f"ur eine "Ubertragsvariable, die damit eingespart werden kann.

@D memberfunction \Natural.add\_no\_inc with 3 arguments
@{bool Natural::add_no_inc(const Digit* pT, Digit* pSum, const Digit* pSmd) const
// Algorithm:  d := x.add_no_inc(r, s, t)
//             Let a,b in Natural.
// Input:      x in Natural,
//             r,s in [a.root, a.p+L(a)] where r < s,
//             t in [b.root, b.p+L(b)] where t-(s-r) also in [b.root, b.p+L(b)].
// Output:     d in bool such that [d] x [r, s[ := [r, s[ + [t-(s-r), t[ ||
{
  CONDITION(pT < pSum);

  Digit c,d;
  do {
    c = *--pSmd;                          // non carry addition
    d = *--pSum;
    *pSum = d += c;
    if (c > d)
      do {
        if (pSum == pT) return true;
        c = *--pSmd;
        d = *--pSum;
        *pSum = d += c+1;                 // addition with carry
      } while (c >= d);
  } while (pSum != pT);
  return false;
}
@| Natural::add_no_inc @}

Hierbei werden die Zeiger (\texttt{pT}, \texttt{pSum}, \texttt{pSmd}) f"ur die Anweisung
\verb|a += b| folgenderma"sen "ubergeben:\\

\begin{minipage}{\linewidth}
Seien $a,b\in\Natural$ mit $\Length(a)-1 = m\geq n = \Length(b)-1$, dann

{\mbox{}\hfill\begin{picture}(170,150)
\put(60,120){\framebox(20,20){$b_n$}}
\put(80,120){\framebox(40,20){$\cdots$}}
\put(120,120){\framebox(20,20){$b_0$}}
\put(140,120){\framebox(20,20){}}
\put(150,90){\makebox(0,0)[b]{\texttt{pSmd}}}
\put(150,102){\vector(0,1){15}}

\put(0,60){\framebox(20,20){$a_m$}}
\put(20,60){\framebox(40,20){$\cdots$}}
\put(60,60){\framebox(20,20){$a_n$}}
\put(80,60){\framebox(40,20){$\cdots$}}
\put(120,60){\framebox(20,20){$a_0$}}
\put(140,60){\framebox(20,20){}}
\put(150,30){\makebox(0,0)[b]{\texttt{pSum}}}
\put(150,42){\vector(0,1){15}}
\put(70,30){\makebox(0,0)[b]{\texttt{pT}}}
\put(70,42){\vector(0,1){15}}

\put(60,28){$\underbrace{\makebox[80pt]{}}_{\mbox{$\Length(b)$}}$}
\put(0,10){$\underbrace{\makebox[140pt]{}}_{\mbox{$\Length(a)$}}$}

\end{picture}\hfill\mbox{}}
\end{minipage}\\[3ex]

Der Additionsalgorithmus bleibt auch weitgehend gleich, wenn wir eine Addition mit zwei verschiedenen Summanden
durchf"uhren, die dem \texttt{operator +} entspricht.

@D memberfunction \Natural.add\_no\_inc with 4 arguments
@{bool Natural::add_no_inc(const Digit* pT, Digit* pSum,
                         const Digit* pSmd1, const Digit* pSmd2) const
// Algorithm:  d := x.add_no_inc(r, s, u, v)
//             Let a,b,c in Natural.
// Input:      x in Natural,
//             r,s in [a.root, a.p+L(a)] where r < s,
//             u in [b.root, b.p+L(b)] where u-(s-r) also in [b.root, b.p+L(b)].
//             v in [c.root, c.p+L(c)] where v-(s-r) also in [c.root, c.p+L(c)].
// Output:     d in bool such that [d] x [r, s[ := [u-(s-r), u[ + [v-(s-r), v[ ||
{
  CONDITION(pT < pSum);

  do {
    Digit c = *--pSmd1;                 // non carry addition
    Digit d = *--pSmd2;
    *--pSum = c += d;
    if (d > c)
      do {
        if (pSum == pT) return true;    // addition with carry
        c = *--pSmd1;
        d = *--pSmd2;
        *--pSum = c += d+1;
      } while (d >= c);
  } while (pSum != pT);
  return false;
}
@| Natural::add_no_inc @}


\subsection{Praxisdemonstration an den Fibonacci-Zahlen}
%-------------------------------------------------------

Die Fibonacci-Zahlen sind definiert durch die Rekursion:\index{Fibonacci-Zahlen}
\[F_0 = 0, F_1 = 1\mbox{ und }F_n = F_{n-1} + F_{n-2}\quad\mbox{ f"ur }n\geq2.\]

Wir verwenden den folgenden Algorithmus, in dem die Addition die entscheidende Rolle spielt:
\label{additiver Fibonacci-Algorithmus}
@d initialization of Fibonacci algorithm
@{Natural k,i,j(1);
@}

@d additive Fibonacci algorithm
@{while (--n) {
  k = i+j;
  if (--n == 0) return k;
  i = j+k;
  if (--n == 0) return i;
  j = k+i;
}@}

Wir werden im Kapitel \ref{Fibonacci-Algorithmus} noch einen wesentlich schnelleren Algorithmus kennenlernen; momentan
liegt jedoch unser Hauptinteresse in der Analyse des Additionsalgorithmus und nicht in der
schnellstm"oglichen Berechnung der Fibonacci-Zahlen.\\
Bei der Analyse betrachten wir verschiedene Compiler auf verschiedenen Betriebssystemen, um die Portabilit"at zu
demonstrieren. Das Programm ist jeweils unter optimalen Bedingungen compiliert und ausgef"uhrt worden, um dadurch
vergleichbare Ergebnisse zu erreichen.\\
F"ur einen Pentium-Rechner mit 100 MHz ergaben sich die folgende Zeiten:\footnotesize\bigskip\\
\hspace*{\fill}\begin{tabular}{l|l|l|l|l}
& Watcom \cpp\ 10.6 (OS/2) & Visual \cpp\ 4.0 & Borland \cpp\ 5.0 & GNU-C 2.7.2 \\
& (OS/2) & (Win32) & (Win32) & (Linux)\\
\hline
\texttt{fib(10000)} & 0.16 s & 0.16 s & 0.15 s & 0.15 s\\
%[2090 Dezimalstellen]\\
\hline
\texttt{fib(100000)} & 18.4 s & 13.5 s & 15.2 s & 14.9 s\\
%[20899 Dezimalstellen]\\
\end{tabular}\hfill\normalsize\bigskip\\
Auf anderen Rechnersystemen unter dem Betriebssystem Unix und mit dem popul"aren GNU-Compiler mit der gleichen
Parameter"ubergabe (\texttt{-O2}) sind folgende Zeiten entstanden:\footnotesize\bigskip\\
\hspace*{\fill}\begin{tabular}{l|c|c|c|c}
& SUN-SPARCstation10 & SUN UltraSPARC & IBM Power PC & HP PA 7100\\
& (40 MHz) & (134 MHz) & (80 MHz) & \\
\hline
\texttt{fib(10000)} & 0.20 s & 0.08 s & 0.13 s & 0.17 s\\
\hline
\texttt{fib(100000)} & 25.5 s & 8.4 s & 12.5 s & 15.7 s
\end{tabular}\hfill\normalsize\bigskip\\

Und mit anderen Compileren:\footnotesize\bigskip\\
\hspace*{\fill}\begin{tabular}{l|l|c|c}
Prozessor & Compiler & \texttt{fib(10000)} & \texttt{fib(100000)}\\
\hline
MIPS R4000 & Silicon Graphics \cpp\ 5.3 &&\\
(100 MHz) & & 0.18 s & 23.15 s\\
\hline
DEC Alpha & DEC \cpp &&\\
(150 MHz) & & 0.07 s & 7.55 s
\end{tabular}\hfill\normalsize\bigskip\\
