\begin{verbatim}
http://www.cecm.sfu.ca/projects/ISC/records.html
http://www.lacim.uqam.ca/pi/records.html

Dear Simon,

I send you Apery's constant to 32,000,213 decimal digits using the formula


                    /                                           \
                    | ------       (n + 1)       2              |
                    |  \       (-1)        (205 n  - 160 n + 32)|
     Zeta(3) =  1/2 |   )      ---------------------------------|
                    |  /               5                 5      |
                    | ------          n  binomial(2 n, n)       |
                    \ n >= 1                                    /


found in [1] by Theodor Amdeberhan and Doron Zeilberger.


The digits have been checked with the previous record and they agree
with all 10,536,006 digits given by Patrick Demichel.
They agree also with my previous computation of 16,00,064 decimals.

I have used the same printing format used by Bruno Haible, Thomas
Papanikolaou and Patrick Demichel for easy "diff" checking.


The computation was done on March 17, 1998 took 35 h 21 min 22 sec on
9 x MIPS R10000 180 MHz, 1 GB RAM, SGI MIPSpro C++ 7.1, IRIX 6.4.



previous computations on a set of 10 Pentiums and 2 UltraSPARC at 200 MHz:

(0)-(7)       0 - 16*10^6 in 77648 sec
(8)-(9) 16*10^6 - 20*10^6 in (8404 sec / 7940 sec) + 11066 sec


partial computations:

(10) 20*10^6 - 22*10^6  in 4105 sec
(11) 22*10^6 - 24*10^6  in 4056 sec
(12) 24*10^6 - 26*10^6  in 4041 sec
(13) 26*10^6 - 28*10^6  in 4067 sec
(14) 28*10^6 - 30*10^6  in 4216 sec
(15) 30*10^6 - 32*10^6  in 4136 sec


combining (parallelized in three processes):

(10)-(11) in 499 sec / 299 sec / 299 sec
(12)-(13) in 532 sec / 257 sec / 264 sec
(14)-(15) in 527 sec / 256 sec / 267 sec

 (8)-(11) in 1122 sec / 568 sec / 573 sec
(12)-(15) in 1133 sec / 566 sec / 557 sec

 (8)-(15) in 7511 sec / 2304 sec / 2381 sec

 (0)-(15) in 24485 sec / 9747 sec / 10677 sec


last division for 32,000,320 digits:

in 1973 sec + 11063 sec


I have taken advantage of the binary splitting method (see [2]), my arithmetic
Piologie Version 1.2.1 (see [3]) and also simplified to the formula


                     /                                             \
                     | ------       n        2                   5 |
                     |  \       (-1)   (205 n  + 250 n + 77) (n!)  |
     Zeta(3) =  1/64 |   )      ---------------------------------- |
                     |  /               n   ---- n          5      |
                     | ------         32    |  |    (2k + 1)       |
                     \ n >= 0               |  |k=0                /


Thanks are going to:

- "Papalizu" Dr. Horst Josef Wedeniwski for a second try to calculate 20*10^6
  digits on a Pentium II 300 MHz with 512 MB RAM, unfortunately after 19*10^6
  digits it gets out of memory.

- Prof. Dr. Rudiger Loos (University of Tuebingen) for the hint to the nine
  MIPS computers, for many pre-calculations and a first try to calculate
  Zeta(3).


Regards,

   Sebastian Wedeniwski  (wedeniws@@informatik.uni-tuebingen.de)


References:

[1] T. Amdeberhan und D. Zeilberger: Hypergeometric Series Acceleration via
    the WZ Method, Electronic Journal of Combinatorics (Wilf Festschrift
    Volume) 4 (1997).

[2] B. Haible, T. Papanikolaou: Fast multiprecision evaluation of series of
    rational numbers, Technical Report TI-97-7, Darmstadt University of
    Technology, April 1997.

[3] S. Wedeniwski: Piologie - Eine exakte arithmetische Bibliothek in C++,
    Technical Report WSI 96-35, Tuebingen University, available by anonymous
    ftp from "ftp://ftp.informatik.uni-tuebingen.de/pub/CA/software/Piologie/"
    or "ftp://ruediger.informatik.uni-tuebingen.de/Piologie/".
\end{verbatim}

@O zeta3.cmd
@{@@echo off
if "%1" == "" goto usage
mkdir 0
cd 0
..\zeta %1 0 8
cd ..
mkdir 1
cd 1
..\zeta %1 1 8
cd ..
mkdir 2
cd 2
..\zeta %1 2 8
cd ..
mkdir 3
cd 3
..\zeta %1 3 8
cd ..
mkdir 4
cd 4
..\zeta %1 4 8
cd ..
mkdir 5
cd 5
..\zeta %1 5 8
cd ..
mkdir 6
cd 6
..\zeta %1 6 8
cd ..
mkdir 7
cd 7
..\zeta %1 7 8
cd ..
mkdir 0-1
cd 0-1
..\zeta 1 ../0/ ../1/
..\zeta 2 ../0/ ../1/
..\zeta 3 ../0/ ../1/
cd ..
mkdir 2-3
cd 2-3
..\zeta 1 ../2/ ../3/
..\zeta 2 ../2/ ../3/
..\zeta 3 ../2/ ../3/
cd ..
mkdir 4-5
cd 4-5
..\zeta 1 ../4/ ../5/
..\zeta 2 ../4/ ../5/
..\zeta 3 ../4/ ../5/
cd ..
mkdir 6-7
cd 6-7
..\zeta 1 ../6/ ../7/
..\zeta 2 ../6/ ../7/
..\zeta 3 ../6/ ../7/
cd ..
mkdir 0-3
cd 0-3
..\zeta 1 ../0-1/ ../2-3/
..\zeta 2 ../0-1/ ../2-3/
..\zeta 3 ../0-1/ ../2-3/
cd ..
mkdir 4-7
cd 4-7
..\zeta 1 ../4-5/ ../6-7/
..\zeta 2 ../4-5/ ../6-7/
..\zeta 3 ../4-5/ ../6-7/
cd ..
mkdir 0-7
cd 0-7
..\zeta 1 ../0-3/ ../4-7/
..\zeta 3 ../0-3/ ../4-7/
..\zeta %1 8 8
..\zeta %1
cd ..
goto finish
:usage
echo usage: zeta3 <decimals>
:finish
@}

@O zeta.cpp
@{#include "pi.h"
#include "integer.h"

#ifdef _Old_STD_
# include <fstream.h>
#else
# include <fstream>
#endif

#include <string.h>
#include <time.h>


class Zeta {
private:
  Fixed zeta;

  void series(size_t, const size_t, Integer&, Integer&, Integer&) const;

public:
  Zeta(const size_t);
  Zeta(const size_t, const size_t, const size_t, const size_t);

  friend ostream& operator<<(ostream&, const Zeta&);
};


inline ostream& operator<<(ostream& out, const Zeta& a)
// Algorithm:  o := operator<<(o, a)
// Input:      o in ostream, a in Zeta3.
// Output:     o in ostream ||
//
// Note:       puts Zeta3 a on output stream.
{
  return out << a.zeta;
}

void Zeta::series(size_t n, const size_t m, Integer& p, Integer& q, Integer& t) const
// n < 2^BETA/205-250
{
  // CONDITION(n < m);
  if (n+1 == m) {
    if (n == 0) { p = 1; q = 32; t = 77; }
    else {
      if (n <= GAMMA_LOW) { p = n*n; p *= n*n; }
      else { p = n; p = p*p; p = p*p; }
      p *= n; p = -p;
      if (n < GAMMA/207) t = 205*n+250;
      else { t = n; t *= 205; t += 250; }
      t *= n; t += 77; t *= p;
      n = 2*n+1;
      if (n <= GAMMA_LOW) { q = n*n; q *= n*n; }
      else { q = n; q = q*q; q = q*q; }
      q *= 32*n;
    }
  } else {
    Integer p1,q1,t1;
    Integer p2,q2,t2;

    const int l = (n+m)/2;
    series(n, l, p1, q1, t1);
    series(l, m, p2, q2, t2);
    t = t1*q2; t += t2*p1;
    p = p1*p2; q = q1*q2;
  }
}

void format()
{
  ifstream fin("zeta3.tmp");
  ofstream fout("zeta3-f.tmp");
  int i = 0;
  char c;
  while (!fin.eof()) {
    if (!fin.get(c)) break;
    fout.put(c);
    if (++i == 78) { fout << "\\\n"; i = 0; }
  }
}

Zeta::Zeta(const size_t n)
 : zeta(n)
{
  ifstream fin("zeta.tmp");
  size_t x;
  fin >> x;
  if (x != zeta.precision()) { cerr << "Note (different BETA)!\n"; }
  char c;
  fin.get(c);
  fin >> x;
  if (x != zeta.decimals()) { cerr << "Error!\n"; return; }
  fin.get(c);
  zeta.value().scan(fin);
}

Zeta::Zeta(const size_t n, const size_t idx, const size_t max, const size_t st)
 : zeta(n)
{
  time_t start,stop;
  const size_t sz = zeta.precision();

  Integer p,q,t;
  if (idx < max) {
    const size_t m = size_t(n/3.0102348);
    const size_t k = m/max;
    const size_t i = k*idx;

    start = time(0);
    if (i+2*k > m) {
      cout << "process:" << idx << ", from " << ((st)? st : i) << " to " << m << endl;
      series((st)? st : i, m, p, q, t);
    } else {
      cout << "process:" << idx << ", from " << ((st)? st : i) << " to " << i+k << endl;
      series((st)? st : i, i+k, p, q, t);
    }
    stop = time(0);
    cout << "zeta time [s] = " << difftime(stop, start) << endl;

    ofstream foutp("zeta-p.tmp");
    ofstream foutq("zeta-q.tmp");
    ofstream foutt("zeta-t.tmp");
    foutp << print(p);
    foutq << print(q);
    foutt << print(t);
  } else {
    ifstream finq("zeta-q.tmp");
    ifstream fint("zeta-t.tmp");
    q.scan(finq);
    t.scan(fint);

    cout << "process division" << endl;
    start = time(0);
    size_t i = 0;
    while (!abs(q).testbit(i)) ++i;
    q >>= i; t <<= BETA*sz-1-i;
    zeta.value() = abs(t) / abs(q);
    stop = time(0);
    cout << "zeta time [s] = " << difftime(stop, start) << endl;
    ofstream fout("zeta.tmp");
    fout << zeta.precision() << ',' << zeta.decimals() << ',' << print(zeta.value());
  }
}

void read(const char* path, const char* name, Integer& q)
{
  char str[100];
  ifstream fin(strcat(strcpy(str, path), name));
  cout << name << " read..." << flush;
  if (q.scan(fin)) cout << "...ok!" << endl;
  else cerr << "...ERROR!\n";
}

void combine(const char* path1, const char* path2, int idx)
{
  time_t start,stop;

  switch (idx) {
  case 1: {
    Integer q,t,p1,t1,z;
    read(path1, "zeta-p.tmp", p1);
    read(path1, "zeta-t.tmp", t1);
    read(path2, "zeta-q.tmp", q);
    read(path2, "zeta-t.tmp", z);

    start = time(0);
    cout << "combine1" << endl;
    t = z*p1;
    cout << "combine2" << endl;
    t += z = t1*q;
    stop = time(0);
    cout << "zeta time [s] = " << difftime(stop, start) << endl;

    ofstream fout("zeta-t.tmp");
    fout << print(t);
    break;
  }
  case 2: {
    Integer p,p1;
    read(path1, "zeta-p.tmp", p1);
    read(path2, "zeta-p.tmp", p);

    start = time(0);
    cout << "combine" << idx << endl;
    p *= p1;
    stop = time(0);
    cout << "zeta time [s] = " << difftime(stop, start) << endl;

    ofstream fout("zeta-p.tmp");
    fout << print(p);
    break;
  }
  case 3: {
    Integer q,q1;
    read(path1, "zeta-q.tmp", q1);
    read(path2, "zeta-q.tmp", q);

    start = time(0);
    cout << "combine" << idx << endl;
    q *= q1;
    stop = time(0);
    cout << "zeta time [s] = " << difftime(stop, start) << endl;

    ofstream foutq("zeta-q.tmp");
    foutq << print(q);
    break;
  }
  default: cerr << "ERROR!\n";
  }
}


int main(int argc, char** argv)
{
  size_t i,j,n,m = 0;
  if (argc == 4) {
    n = atoi(argv[1]);
    if (n >= 1 && n <= 3) {
      combine(argv[2], argv[3], n);
      return 0;
    }
    i = atoi(argv[2]);
    j = atoi(argv[3]);
  } else if (argc == 5) {
    n = atoi(argv[1]);
    i = atoi(argv[2]);
    j = atoi(argv[3]);
    m = atoi(argv[4]);
  } else if (argc == 2) {
    Zeta z(atoi(argv[1]));
    time_t start,stop;
    ofstream fout("zeta3.tmp");
    start = time(0);
    fout << z << endl;
    stop = time(0);
    cout << "zeta time [s] = " << difftime(stop, start) << endl;

    fout.close();
    format();
    return 0;
  } else {
    cout << "useage:  zeta <decimals> <step> <parts> [start]\n";
    cout << "      or zeta <decimals>\n";
    cout << "      or zeta <idx> <path1> <path2>\n";
    return 1;
  }

  Zeta z(n, i, j, m);

  return 0;
}
@}