///////////////////////////////
//
// Piologie V1.2.1
// multi-precision arithmetic
// Primes
//
// Sebastian Wedeniwski
// 03/18/1998
//


#ifndef _Include_Primes_H_
#define _Include_Primes_H_

#include "natural.h"

template <class Container>
void factoring(Natural a, Container& p)
// Algorithm:  factoring(a, c)
// Input:      a in Natural.
// Output:     c is a container over Natural with output-iterator
//             such that if a >= 1 then a = prod_{c.begin() <= i < c.end()} *i
//             else c.begin() = c.end(),
//             for all i in [c.begin(), c.end()[, j in [i, c.end()[ : *i <= *j ||
{
  p.erase(p.begin(), p.end());
  if (a == 0) return;
  while (a.even()) {                      // less factors
    p.push_back(2);
    a >>= 1;
  }
  if (a == 1) return;
  Natural t;
  Digit i;
  Digit prim = a.firstPrime();            // didn't need 2
  while (a.nextPrime(prim)) {
    while (true) {
      div(a, prim, t, i);
      if (i) break;
      p.push_back(prim);
      if (t == 1) return;
      swap(a, t);
    }
    if (t < prim) { p.push_back(a); return; }
  }
  
  if (a.isprime() == 1) { p.push_back(a); return; }     // greater
  Natural s = prim;
  const Digit n[8] = { 4, 2, 4, 2, 4, 6, 2, 6 };
  i = 0;
  switch (s % 30) {
    case 1:  ++i;
    case 29: ++i;
    case 23: ++i;
    case 19: ++i;
    case 17: ++i;
    case 13: ++i;
    case 11: ++i;
  }
  Natural q,r;
  t = root(a, 3);
  for (s += n[i]; s.length() == 1 && s <= t; s += n[i&7]) {
    if (a%s.highest() == 0) {
      p.push_back(s);
      a /= s.highest();
      if (a.isprime() == 1) { p.push_back(a); return; }
      t = root(a, 3);
    }
    ++i;
  }
  while (s <= t) {
    div(a, s, q, r);
    if (r == 0) {
      p.push_back(s);
      if (q.isprime() == 1) { p.push_back(q); return; }
      swap(a, q);
      t = root(a, 3);
    }
    ++i;
    s += n[i&7];
  }
  
  Natural w;                                        // large factors
  sqrt(a, s, w);
  if (w == 0) { p.push_back(s); p.push_back(s); return; }
  s = root(a, 6);
  q = a << 2;
  t *= a; t <<= 2;

  Natural x,y,z,d = 4;
  Natural e = 2;
  r = s >> 2;
  const char c[32] = { 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
                       1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0 };
  Natural k = q;
  for (; k <= t; k += q) {
    if (e == 0) {
      d += 4;
      if (d > s) break;
      r = d >> 1;
      div(s, d, r, x);
    } else --e;
    sqrt(k, x, y);
    z = x << 1; ++x; ++z; z -= y;
    while (true) {
      if (c[z.lowest() & 31]) {
        sqrt(z, y, w);
        if (w == 0) {
          y = gcd(x+y, a);
          a /= y;
          if (y < a) { p.push_back(y); p.push_back(a); }
          else { p.push_back(a); p.push_back(y); }
          return;
        }
      }
      if (r == 0) break;
      --r; z = x << 1; ++x; ++z;
    }
  } 
  while (k <= t) {
    sqrt(k, x, z);
    y = x << 1; ++x; ++y; y -= z;
    if (c[y.lowest() & 31]) {
      sqrt(y, y, w);
      if (w == 0) {
        y = gcd(x+y, a);
        a /= y;
        if (y < a) { p.push_back(y); p.push_back(a); }
        else { p.push_back(a); p.push_back(y); }
        return;
      }
    } 
    k += q;
  }
  p.push_back(a);
}

#endif
