#include "pi.h"
#include "integer.h"

#ifdef _Old_STD_
# include <fstream.h>
#else
# include <fstream>
#endif

#include <string.h>
#include <time.h>


class Zeta {
private:
  Fixed zeta;

  void series(size_t, const size_t, Integer&, Integer&, Integer&) const;

public:
  Zeta(const size_t);
  Zeta(const size_t, const size_t, const size_t, const size_t);

  friend ostream& operator<<(ostream&, const Zeta&);
};


inline ostream& operator<<(ostream& out, const Zeta& a)
// Algorithm:  o := operator<<(o, a)
// Input:      o in ostream, a in Zeta3.
// Output:     o in ostream ||
//
// Note:       puts Zeta3 a on output stream.
{
  return out << a.zeta;
}

void Zeta::series(size_t n, const size_t m, Integer& p, Integer& q, Integer& t) const
// n < 2^BETA/205-250
{
  // CONDITION(n < m);
  if (n+1 == m) {
    if (n == 0) { p = 1; q = 32; t = 77; }
    else {
      if (n <= GAMMA_LOW) { p = n*n; p *= n*n; }
      else { p = n; p = p*p; p = p*p; }
      p *= n; p = -p;
      if (n < GAMMA/207) t = 205*n+250;
      else { t = n; t *= 205; t += 250; }
      t *= n; t += 77; t *= p;
      n = 2*n+1;
      if (n <= GAMMA_LOW) { q = n*n; q *= n*n; }
      else { q = n; q = q*q; q = q*q; }
      q *= 32*n;
    }
  } else {
    Integer p1,q1,t1;
    Integer p2,q2,t2;

    const int l = (n+m)/2;
    series(n, l, p1, q1, t1);
    series(l, m, p2, q2, t2);
    t = t1*q2; t += t2*p1;
    p = p1*p2; q = q1*q2;
  }
}

void format()
{
  ifstream fin("zeta3.tmp");
  ofstream fout("zeta3-f.tmp");
  int i = 0;
  char c;
  while (!fin.eof()) {
    if (!fin.get(c)) break;
    fout.put(c);
    if (++i == 78) { fout << "\\\n"; i = 0; }
  }
}

Zeta::Zeta(const size_t n)
 : zeta(n)
{
  ifstream fin("zeta.tmp");
  size_t x;
  fin >> x;
  if (x != zeta.precision()) { cerr << "Note (different BETA)!\n"; }
  char c;
  fin.get(c);
  fin >> x;
  if (x != zeta.decimals()) { cerr << "Error!\n"; return; }
  fin.get(c);
  zeta.value().scan(fin);
}

Zeta::Zeta(const size_t n, const size_t idx, const size_t max, const size_t st)
 : zeta(n)
{
  time_t start,stop;
  const size_t sz = zeta.precision();

  Integer p,q,t;
  if (idx < max) {
    const size_t m = size_t(n/3.0102348);
    const size_t k = m/max;
    const size_t i = k*idx;

    start = time(0);
    if (i+2*k > m) {
      cout << "process:" << idx << ", from " << ((st)? st : i) << " to " << m << endl;
      series((st)? st : i, m, p, q, t);
    } else {
      cout << "process:" << idx << ", from " << ((st)? st : i) << " to " << i+k << endl;
      series((st)? st : i, i+k, p, q, t);
    }
    stop = time(0);
    cout << "zeta time [s] = " << difftime(stop, start) << endl;

    ofstream foutp("zeta-p.tmp");
    ofstream foutq("zeta-q.tmp");
    ofstream foutt("zeta-t.tmp");
    foutp << print(p);
    foutq << print(q);
    foutt << print(t);
  } else {
    ifstream finq("zeta-q.tmp");
    ifstream fint("zeta-t.tmp");
    q.scan(finq);
    t.scan(fint);

    cout << "process division" << endl;
    start = time(0);
    size_t i = 0;
    while (!abs(q).testbit(i)) ++i;
    q >>= i; t <<= BETA*sz-1-i;
    zeta.value() = abs(t) / abs(q);
    stop = time(0);
    cout << "zeta time [s] = " << difftime(stop, start) << endl;
    ofstream fout("zeta.tmp");
    fout << zeta.precision() << ',' << zeta.decimals() << ',' << print(zeta.value());
  }
}

void read(const char* path, const char* name, Integer& q)
{
  char str[100];
  ifstream fin(strcat(strcpy(str, path), name));
  cout << name << " read..." << flush;
  if (q.scan(fin)) cout << "...ok!" << endl;
  else cerr << "...ERROR!\n";
}

void combine(const char* path1, const char* path2, int idx)
{
  time_t start,stop;

  switch (idx) {
  case 1: {
    Integer q,t,p1,t1,z;
    read(path1, "zeta-p.tmp", p1);
    read(path1, "zeta-t.tmp", t1);
    read(path2, "zeta-q.tmp", q);
    read(path2, "zeta-t.tmp", z);

    start = time(0);
    cout << "combine1" << endl;
    t = z*p1;
    cout << "combine2" << endl;
    t += z = t1*q;
    stop = time(0);
    cout << "zeta time [s] = " << difftime(stop, start) << endl;

    ofstream fout("zeta-t.tmp");
    fout << print(t);
    break;
  }
  case 2: {
    Integer p,p1;
    read(path1, "zeta-p.tmp", p1);
    read(path2, "zeta-p.tmp", p);

    start = time(0);
    cout << "combine" << idx << endl;
    p *= p1;
    stop = time(0);
    cout << "zeta time [s] = " << difftime(stop, start) << endl;

    ofstream fout("zeta-p.tmp");
    fout << print(p);
    break;
  }
  case 3: {
    Integer q,q1;
    read(path1, "zeta-q.tmp", q1);
    read(path2, "zeta-q.tmp", q);

    start = time(0);
    cout << "combine" << idx << endl;
    q *= q1;
    stop = time(0);
    cout << "zeta time [s] = " << difftime(stop, start) << endl;

    ofstream foutq("zeta-q.tmp");
    foutq << print(q);
    break;
  }
  default: cerr << "ERROR!\n";
  }
}


int main(int argc, char** argv)
{
  size_t i,j,n,m = 0;
  if (argc == 4) {
    n = atoi(argv[1]);
    if (n >= 1 && n <= 3) {
      combine(argv[2], argv[3], n);
      return 0;
    }
    i = atoi(argv[2]);
    j = atoi(argv[3]);
  } else if (argc == 5) {
    n = atoi(argv[1]);
    i = atoi(argv[2]);
    j = atoi(argv[3]);
    m = atoi(argv[4]);
  } else if (argc == 2) {
    Zeta z(atoi(argv[1]));
    time_t start,stop;
    ofstream fout("zeta3.tmp");
    start = time(0);
    fout << z << endl;
    stop = time(0);
    cout << "zeta time [s] = " << difftime(stop, start) << endl;

    fout.close();
    format();
    return 0;
  } else {
    cout << "useage:  zeta <decimals> <step> <parts> [start]\n";
    cout << "      or zeta <decimals>\n";
    cout << "      or zeta <idx> <path1> <path2>\n";
    return 1;
  }

  Zeta z(n, i, j, m);

  return 0;
}
