#include <stddef.h>
#include <iostream.h>
#include <fstream.h>


#if !defined(__AP_H)
#define __AP_H


// Uncomment if you are _sure_ that no memory allocation or file I/O will fail
// #define NDEBUG

#include <assert.h>


// Assembler optimizations
// ASM should be defined in the makefile

#if defined (ASM)
#define USEASM
#endif


// Global variables

extern size_t Ramsize;
extern size_t CacheL1size;
extern size_t CacheL2size;
extern size_t Cacheburst;
extern size_t Cachetreshold;
extern size_t Cacheburstblocksize;
extern size_t Cachemaxblocksize;
extern size_t Cacheblocksize;
extern size_t Maxblocksize;
extern size_t Memorytreshold;
extern size_t Blocksize;

extern int Basedigits;

extern int fno;


// These use stuff declared until now
#include "modint.h"
#include "bigint.h"


extern rawtype Base;
extern rawtype Basedigit;
extern rawtype Basefactors[];
extern int NBasefactors;

extern rawtype primetable[];
extern rawtype moduli[3];
extern rawtype primitiveroots[3];
extern rawtype wftamoduli[3];
extern rawtype wftaprimitiveroots[3];
extern rawtype modulus;

extern rawtype *workspace;
extern int workspaceused;


// Variables for WFTA

/*
extern modint *w_0[];
extern modint *iw_0[];
extern modint *w_1[];
extern modint *iw_1[];
extern modint *w_2[];
extern modint *iw_2[];
extern int n[];
extern int *s[];
extern int m[];
extern int *ms[];
extern int *p[];
extern int *ip[];
*/


// Standard functions that are included in unknown include files

extern "C"
{
    int remove (const char *filename);
    int truncate (const char *filename, unsigned long size);
}


// Functions in init.cc

bool apinit (void);
void apdeinit (void);
void setmodulus (rawtype m);
void clearmodulus (void);
void apbase (rawtype basedigit);


// Functions in prime.cc

bool isprime (rawtype n);
rawtype nextprime (rawtype n);
rawtype getprime (rawtype n, rawtype u = MAXMODULUS);
size_t factor (rawtype f[], rawtype n);
modint primitiveroot (void);
void initmoduli (rawtype n);

// Functions in crt.cc

void crt (rawtype *r, rawtype *m, size_t n);


// Functions in move.cc

#if defined (USEASM)
extern "C"
{
#endif

void moveraw (void *d, void *s, size_t n);
void swapraw (void *d, void *s, size_t n);

#if defined (USEASM)
}
#endif


// Functions in file.cc

char *filename (int fno);


// Functions in scramble.cc

size_t permute (size_t n, size_t nn);
void scramble (modint data[], size_t nn);
void initscrambletable (size_t ptable[], size_t nn);
void tablescramble (modint data[], size_t ptable[]);


// Functions in transpos.cc

void transposesquare (modint data[], size_t n1, size_t n2);
void transpose (modint data[], size_t n1, size_t n2);


// Functions in fnt.cc

void fnt (modint data[], modint pr, int isign, size_t nn, int s = 1);
void ifnt (modint data[], modint pr, int isign, size_t nn, int s = 1);


// Functions in tablefnt.cc

#if defined (USEASM)
extern "C"
{
#endif

void tablefnt (modint data[], modint wtable[], size_t ptable[], size_t nn, int s = 1);
void itablefnt (modint data[], modint wtable[], size_t ptable[], size_t nn, int s = 1);

#if defined (USEASM)
}
#endif


// Functions in fourstep.cc

void fourstepfnt (modint data[], modint pr, int isign, size_t nn);
void ifourstepfnt (modint data[], modint pr, int isign, size_t nn);


// Functions in tablefou.cc

void tablefourstepfnt (modint data[], modint pr, int isign, size_t nn);
void itablefourstepfnt (modint data[], modint pr, int isign, size_t nn);


// Functions in sixstep.cc

void sixstepfnt (modint data[], modint pr, int isign, size_t nn);
void isixstepfnt (modint data[], modint pr, int isign, size_t nn);


// Functions in tablesix.cc

void tablesixstepfnt (modint data[], modint pr, int isign, size_t nn, int t = 3);
void itablesixstepfnt (modint data[], modint pr, int isign, size_t nn, int t = 3);


// Functions in tablesit.cc

void tablesixstepfnttrans (modint data[], modint pr, int isign, size_t nn);
void tablesixstepfnttrans2 (modint data[], modint pr, int isign, size_t nn);
void itablesixstepfnttrans (modint data[], modint pr, int isign, size_t nn);
void itablesixstepfnttrans2 (modint data[], modint pr, int isign, size_t nn, size_t e = 1);


// Functions in wfta.cc

void createpermutetables (void);
void createwtables (modint pr, modint *wt[], modint *iwt[], modint *w[], modint *iw[]);
void wfta (modint x[], modint *w[], int nn);


// Functions in sixwftat.cc

void sixstepwftatrans (modint data[], modint *w[], modint pr, int isign, int n1, int n2);
void isixstepwftatrans (modint data[], modint *w[], modint pr, int isign, int n1, int n2);


// Functions in tabletwo.cc

void tabletwopassfnt (fstream &in, modint pr, int isign, size_t nn);
void itabletwopassfnt (fstream &in, modint pr, int isign, size_t nn);


// Functions in tabletwt.cc

void tabletwopassfnttrans (fstream &in, modint pr, int isign, size_t nn);
void tabletwopassfnttrans2 (fstream &in, modint pr, int isign, size_t nn, size_t o = 0);
void itabletwopassfnttrans (fstream &in, modint pr, int isign, size_t nn);
void itabletwopassfnttrans2 (fstream &in, modint pr, int isign, size_t nn, size_t o = 0, size_t e = 1);


// This uses stuff declared until now
#include "apfloat.h"


// Misc. functions

// Functions in carrycrt.cc

int carrycrt (apstruct *ds1, apstruct *s2, apstruct *s3, size_t rsize);


// Functions in convolut.cc

void multiplyinplace (apstruct *ds1, apstruct *s2);
void squareinplace (apstruct *ds);
apstruct *convolution (apstruct *s1, apstruct *s2, size_t rsize, size_t s1size, size_t s2size, size_t n, int *i);
apstruct *autoconvolution (apstruct *s, size_t rsize, size_t ssize, size_t n, int *i);


#endif  // __AP_H
