//
// simple example 4: 
// compute pi using different convolutions
//

#include  "../src/include/hfloatfu.h"
#include  "../src/include/mybuiltin.h"  // for start_timer() and return_elapsed_time()
#include  "../src/include/convolut.h"   // for set_???_convl()


int main()
{
    // precision in LIMBs, use o power of two:
    hfloat::max_prec(1024);

    // radix, use 10000 (decimal) or 65536 (hex numbers):
    hfloat::radix(65536);


    hfloat pi1, pi2, d;

    // choose some convolution (fht is the default):
    //    set_mul_convolution(FHT_CNVL);
    //    set_sqr_convolution(FHT_AUTO_CNVL);


    // first pi:
    start_timer();
    pi_4th_order(pi1);
    double dt1=return_elapsed_time();
    print("\n pi1=\n", pi1, 44);
    print_last("\n last digits are \n", pi1, 16);



    // choose another convolution:

    //    set_mul_convolution(FHT_CNVL);
    //    set_mul_convolution(WRAP_FFT_CNVL);
    //    set_mul_convolution(SPLIT_RADIX_FFT_CNVL);
    //    set_mul_convolution(FHT_FFT_CNVL);
    set_mul_convolution(NTT_CNVL);
    //    set_mul_convolution(SLOW_CNVL);

    //    set_sqr_convolution(FHT_CNVL);
    //    set_sqr_convolution(WRAP_FFT_CNVL);
    //    set_sqr_convolution(SPLIT_RADIX_FFT_CNVL); 
    //    set_sqr_convolution(FHT_FFT_CNVL);
    set_sqr_convolution(NTT_CNVL);
    //    set_sqr_convolution(SLOW_CNVL);


    // second pi computation:
    start_timer();
    pi_4th_order(pi2);
    double dt2 = return_elapsed_time();
    print("\n pi2=\n", pi2, 44);
    print_last("\n last digits are \n", pi2, 16);


    cout << "\n pi1 took " << dt1 << " seconds ";
    cout << "\n pi2 took " << dt2 << " seconds ";


    d =  pi1;
    d -= pi2;


    cout << "\n difference of the results should be exactly zero:";
    print("\n p1-p2= ",d,30);

    if ( 0==d )  cout << "  ok." << endl;
    else         cout << "  *** ! OOPS ! ***" << endl;


    return 0;
}
//---------------
