//
// simple example 5: 
// continued fraction of pi
//


#include  "../src/include/hfloatfu.h"



int main()
{
    // precision in LIMBs, use o power of two:
    hfloat::max_prec(512);

    // radix, use 10000 (decimal) or 65536 (hex numbers):
    hfloat::radix(10000);


    // ----- compute some constant:
    hfloat p,t;
    pi_4th_order(p);
    print("pi=",p,32);

    /*  // uncomment for alternative constant:
    t = 163;
    sqrt(t,t);
    t /= 3;
    t *= p;
    exp(t,t);
    p = t;
    print("exp(pi*sqrt(163)/9)=",p,32);
    */

    // ----- compute continued fraction:
    unsigned long m=3*p.prec(); // how many cf terms 
    long cf[m];
    m = 100;

    hfloat_to_contfrac(p,m,cf);
    cout << " continued fraction: " << endl;
    for (int k=0; k<m; ++k)  
    {
        cout << cf[k] << ", ";
        if ( k%10==0 ) cout << endl;
    }
    cout << endl;

    // ----- cont fract to hfloat:
    contfrac_to_hfloat(cf,m,t);
    t -= p;
    print("t-pi=",t,32);


    // ----- voodoo test:
    contfrac_to_ratio(cf,m-1,p,t);  // max m-1 here

    return 0;
}
//---------------
