//
// simple example 6: 
// alternating sums
//


#include  "../src/include/hfloatfu.h"
#include  "../src/include/mybuiltin.h"  // for start_timer() and return_elapsed_time()


void
gregory_term(ulong k, hfloat &t)
// for arctan(1) = \sum_{k=0}^{\infty}{(-1)^k*1/(2*k+1)}
{
    t = 1;
    if ( k&1 )  t.negate();

    t /= (2*k+1);
}
//---------------


void
catalan_term(ulong k, hfloat &t)
// for catalan = \sum_{k=0}^{\infty}{(-1)^k*1/(2*k+1)}
{
    t = 1;
    if ( k&1 )  t.negate();

    t /= ((2*k+1)*(2*k+1));
}
//---------------


void
zeta3_term(ulong k, hfloat &t)
// for zeta(3) = \sum_{k=0}^{\infty}{1/k^3}
//   == 5/2 * \sum_{k=1}^{\infty}{(-1)^k/(k^3*binomial(2k,k))}
// note that *x remains in memory 
{
    static long kk = -99;
    static hfloat *x = NULL;  // 1/binomial(2k,k)

    k += 1;

    if ( k==1 )
    {
        if ( x )  delete x;

        x = new hfloat(t.prec());
        *x = 1;
        *x /= 2;
    }
    else
    {
        if ( kk!=(k-1) )  assert( 0 );

        *x /= (4*k-2);
        *x *= k;
        
    }

    //    print("\n 1/binomial(2k,k)=",*x,8);

    t = *x;

    t /= k;
    t /= k;
    t /= k;

    if ( !(k&1) )  t.negate();
    //    print("\n (-1)^k/binomial(2k,k)/k^3=",t,8);

    kk = k;

    //    if ( k==17 )  exit(0);
}
//---------------



int main()
{
    // precision in LIMBs, use o power of two <= 256:
    hfloat::max_prec(64);

    // radix, use 10000 (decimal) or 65536 (hex numbers):
    hfloat::radix(10000);


    hfloat s;
    cout << " decimal precision=" << s.dec_prec() << endl;


    // ------ pi:
    start_timer();
    sumalt(gregory_term,s);  // compute pi as arctan(1)
    s *= 4;
    print("\n sumalt pi=\n",s);
    cout<<"\n elapsed time="<<return_elapsed_time()<<" seconds "<<endl;

    hfloat p;
    pi_4th_order(p);
    print("cf. pi=\n",p,16);

    p -= s;
    print("diff=",p,8);


    // ------ catalan:
    sumalt(catalan_term, s);  // compute catalan=0.91596...
    print("\n sumalt catalan=\n",s);
    cout<<"\n elapsed time="<<return_elapsed_time()<<" seconds "<<endl;


    // ------ zeta(3):
    sumalt(zeta3_term, s);
    s *= 5;
    s /= 2;
    print("\n sumalt zeta(3)=\n",s);
    cout<<"\n elapsed time="<<return_elapsed_time()<<" seconds "<<endl;
   

    return 0;
}
//---------------
