
#include <assert.h>

#include "hfdatafu.h"
#include "convolut.h"
#include "auxid.h"
#include "workspace.h"


// for debug:
#include <iostream.h>



//#define  DBL(d)  ((double)(1.0/rx*(d[0]+1.0/rx*(d[1]+1.0/rx*(d[2]+1.0/rx*d[3])))))

int
dt_mul_sqr(const hfdata &a, ulong an, const hfdata &b, ulong bn, 
           hfdata &c, ulong cn)
//
// use a*b = ((a+b)^2 - (a-b)^2))/4
//
// return: if(right_shift occured) (!) 
//
{
    const LIMB* ad = a.dig();
    const LIMB* bd = b.dig();
    LIMB* cd = c.dig();
    const unsigned rx = hfdata::rx;
    int  cy;
    int  i;

    const ulong xn = cn;
    hfdata x(xn);
    LIMB* xd = x.dig();


    // -------- x= u := (a+b)^2
    cy = i_add(ad, an, bd, bn, xd, xn, rx);

    i_shift_right(xd, xn);
    xd[0] = cy;

    cy = i_sqr_fxt(xd, xn, xd, xn, x.dtxdig, rx);
    assert( 0==cy );

    // -------- c= v := (a-b)^2
    long d = dt_cmp(a, an, b, bn);

    if( d>0 )  // a>b
    {
        cy = i_sub(ad, an, bd, bn, cd, cn, rx);
    }
    else       // b>a
    {
        cy = i_sub(bd, bn, ad, an, cd, cn, rx);
    }

    assert( 0==cy );  // pos.

    i_shift_right(cd, cn);
    cd[0] = 0;

    cy = i_sqr_fxt(cd, cn, cd, cn, c.dtxdig, rx);
    assert( 0==cy );

    // --- (u-v)/4:
    cy = i_sub(xd, xn, cd, cn, cd, cn, rx);
    assert( 0==cy );  // u > v


    i = i_div_sh(cd, cn, 4, rx, NULL);

    assert( (i==1) || (i==2) );

    return 2-i;
}
//===================== end DT_MUL_SQR ================================
