#if !defined __CFFTAUX_H
#define      __CFFTAUX_H


#include <complex.h>
#if defined __COMPLEXT__
#define Complex complex<double>
#endif

// cfftaux.cc:
void complex_to_real_imag(Complex *c, long n);
void real_imag_to_complex(double *fr, double *fi, long n);
void c_scramble(Complex *f, long n);
void c_print(char *what, Complex *c, long n);
void c_copy(Complex *src, Complex *dst, long n);
void dc_copy(double *srcre, double *srcim, Complex *dst, long n);
void cd_copy(Complex *src, double *dstre, double *dstim, long n);
void c_null(Complex *dst, long n);
void c_fill(Complex *dst, long n, Complex val);
void c_rand(Complex *a, long n);


#endif // !defined __CFFTAUX_H
