
#include <assert.h>

#include "fxt.h"
#include "fxtaux.h"


void 
fht_fft_convolution(double *f, double *g, ulong ldn)
{
    assert( f!=g );

    fht_real_complex_fft(f,ldn);
    fht_real_complex_fft(g,ldn);

    fft_convolution_core1(f,g,ldn);

    fht_complex_real_fft(g,ldn);
}
//============ end FHT_FFT_CONVOLUTION ===============


void 
split_radix_fft_convolution(double *f, double *g, ulong ldn)
{
    assert( f!=g );

    split_radix_real_complex_fft(f,ldn);
    split_radix_real_complex_fft(g,ldn);

    fft_convolution_core1(f,g,ldn);

    split_radix_complex_real_fft(g,ldn);
}
//=========================== end SPLIT_RADIX_FFT_CONVOLUTION =================


void 
wrap_fft_convolution(double *f, double *g, ulong ldn)
{
    assert( f!=g );

    wrap_real_complex_fft(f,ldn);
    wrap_real_complex_fft(g,ldn);

    fft_convolution_core2(f,g,ldn);

    wrap_complex_real_fft(g,ldn);
}
//=========================== end WRAP_FFT_CONVOLUTION =================


void 
fht_fft_convolution0(double *f, double *g, ulong ldn)
{
    assert( f!=g );

    fht_real_complex_fft0(f,ldn);
    fht_real_complex_fft0(g,ldn);

    fft_convolution_core1(f,g,ldn);

    fht_complex_real_fft(g,ldn);
}
//============ end FHT_FFT_CONVOLUTION0 ===============


void 
split_radix_fft_convolution0(double *f, double *g, ulong ldn)
{
    assert( f!=g );

    split_radix_real_complex_fft0(f,ldn);
    split_radix_real_complex_fft0(g,ldn);

    fft_convolution_core1(f,g,ldn);

    split_radix_complex_real_fft(g,ldn);
}
//=========================== end SPLIT_RADIX_FFT_CONVOLUTION0 =================


void 
wrap_fft_convolution0(double *f, double *g, ulong ldn)
{
    assert( f!=g );

    wrap_real_complex_fft0(f,ldn);
    wrap_real_complex_fft0(g,ldn);

    fft_convolution_core2(f,g,ldn);

    wrap_complex_real_fft(g,ldn);
}
//=========================== end WRAP_FFT_CONVOLUTION0 =================


void
fft_convolution_core1(double *f, double *g, ulong ldn)
{
    const ulong n  = (1<<ldn);
    const ulong nh = n/2;

    g[0]  *= f[0];
    g[nh] *= f[nh];

    for (ulong i=1,j=n-1; i<nh; ++i,--j)
    {
        cmult4(f[i],f[j],g[i],g[j]);
    }

    d_multiply(g,n,1.0/n);
}
//================== end FFT_CONVOLUTION_CORE1 =============


void
fft_convolution_core2(double *f, double *g, ulong ldn)
{
    const ulong n  = (1<<ldn);
    const ulong nh = n/2;

    g[0]  *= f[0];
    g[nh] *= f[nh];

    for (ulong i=1,j=nh+1; i<nh; ++i,++j)
    {
        cmult4(f[i],f[j],g[i],g[j]);
    }

    d_multiply(g,n,1.0/n);
}
//================== end FFT_CONVOLUTION_CORE2 =============
