
#include <assert.h>

#include "fxt.h"
#include "fxtaux.h"


void 
fht_correlation0(double *f, double *g, ulong ldn)
//
// result in g
// 
{
    assert( f!=g );

    const ulong n=(1<<ldn);
    const ulong nh=(n>>1);  

    fht_real_complex_fft0(f,ldn);
    fht_real_complex_fft0(g,ldn);

    g[0] *=f[0];
    g[nh]*=f[nh];

    for(ulong i=1,j=n-1; i<nh; ++i,--j)
    {
        cmult4(f[i],-f[j],g[i],g[j]);
    }

    fht_complex_real_fft(g,ldn);

    d_multiply(g,n,1.0/n);
}
//=============== end FHT_CORRELATION0 ===============


void
fht_auto_correlation0(double *f, ulong ldn)
{
    const ulong n=(1<<ldn);
    const ulong nh=(n>>1);
    const double dn=1.0/n;

    fht_real_complex_fft0(f,ldn);

    f[0]*=f[0];
    f[nh]*=f[nh];

    for(ulong i=1,j=n-1; i<nh; ++i,--j)
    {
        f[i]=(f[i]*f[i]+f[j]*f[j])*dn;
        f[j]=0.0;
    }

    fht_complex_real_fft(f,ldn);
}
//============ end FHT_AUTO_CORRELATION0 ==============

