
#include <assert.h>
#include <math.h>
#include <iostream.h>

#include "mod.h"

#define NFAC (65)      // set to # of bits + 1

static umod_t f[NFAC];

void
print_factors()
{
    int k=0;
    while ( f[k] )
    {
	cout<<f[k]<<", ";
	++k;
    }

    cout<<endl;
}


umod_t
is_factor(umod_t n, umod_t f)
//
// if f divides n  return n/f
// else            return 0
//
{
    umod_t q=n/f;

    if ( q*f==n )  return q;
    else           return 0;
}
//----------------- end is_factor ----------------


umod_t* 
prime_factors(umod_t n)
//
// find factors of n
// returns array with all prime factors of n
// multiple prime factors appear multiple times
//
{
    for(ulong i=0; i<NFAC; ++i)  f[i]=0;

    ulong fct=0;
    umod_t maxf;

    while( ((n&1)==0) )  // n even
    {
	n >>= 1;

	f[fct]=2;

	fct++;
	if( n==1 )  goto ende;
    }

    maxf = (umod_t)(sqrt((double)n)+1);

    for(umod_t v=3; v<=maxf; v+=2)
    {
	umod_t q = is_factor(n,v);

	while( q!=0 )
	{
	    n = q;

	    f[fct] = v;

	    fct++;
	    if( n==1 )  goto ende;

	    maxf = (umod_t)(sqrt((double)n)+1);

	    q = is_factor(n,v);
	}
    }

    f[fct] = n;  // n is prime

ende:

    return f;
}
//----------------- end factor ----------------


umod_t* 
distinct_prime_factors(umod_t n)
//
// returns array with all distinct prime factors of n
//
{
    umod_t *p=prime_factors(n);
    umod_t t,v=0;

    ulong fct=0, fct2=0;
    while( 1 )
    {
	t=f[fct];

	if( t==0 )
	{
	    f[fct2]=0;
	    return p;
	}

	if( t>v )
	{
	    f[fct2]=t;
	    //	    cout<<" distinct["<<fct2<<"]= "<<f[fct2]<<endl;

	    fct2++;
	    v=t;
	}
	
	fct++;
    }

    assert( 0 );  // never come here 
}
//----------------- end factors ----------------
