#if !defined __MOD_H
#define      __MOD_H


#include <iostream.h>



typedef int                   int32;
typedef unsigned int         uint32;

typedef unsigned long        ulong;

typedef long long             int64;
typedef unsigned long long   uint64;


#define USE_64BIT_MOD_T

// choose umod_t for (exact) 32 or 64 bit modulus:
//#define USE_UNSIGNED_MOD_T  // do not use !

// types for class mod:
#ifdef USE_64BIT_MOD_T
typedef uint64               umod_t;
typedef  int64               smod_t;
#else
typedef uint32               umod_t;
typedef  int32               smod_t;
#endif // defined USE_64BIT_MOD_T


#ifdef USE_UNSIGNED_MOD_T
typedef  umod_t               mod_t;
#else
typedef  smod_t               mod_t;
#endif

// the class 'mod_init' has the sole purpose
// of initialising the class 'mod' 
// this is done with the (last) static member 'mod_zero'
// of class 'mod'
// this nice idea is from Mikko Tommila


class mod_init
{
public:
    mod_init(mod_t);
    ~mod_init();
};
//--------------------------


class mod
{
public:

    mod();
    mod(const smod_t);
    mod(const umod_t);

#ifdef USE_64BIT_MOD_T
    mod(const long);
    mod(const ulong);
    //    void mod::set_x(ulong);
    mod & mod::operator = (const ulong);
    mod & mod::operator = (const long);
#else

#endif

    void mod::set_x(const umod_t);


    mod(const mod &);

    ~mod();

    mod_t mod::get_x() const;

    mod & mod::operator = (const umod_t);
    mod & mod::operator = (const smod_t);
    mod & mod::operator = (const mod &);

    mod & mod::operator += (const mod &);
    mod & mod::operator -= (const mod &);
    mod & mod::operator *= (const mod &);
    //mod & mod::operator /= (const mod &);

    mod & mod::operator += (const mod_t);
    mod & mod::operator -= (const mod_t);
    mod & mod::operator *= (const mod_t);
    //mod & mod::operator /= (const mod_t);

    mod & mod::sqr();

    int mod::check() const;


    // --- IMPLEMENTATION:
    mod_t x;

    static mod_t one;
    static mod_t modulus;
    static double m1d;           // 1.0/modulus 
    static long double m1dd;     // 1.0/modulus 
    static mod_t primroot;
    static mod_t inverse_primroot;
    static umod_t phim1;          // phi(modulus)-1


    /*
    // --- Montgomery section: (currently unused) 
    static ulong  mg_bits;       // Montgomery ld(R)
    static umod_t mg_mask;       // Montgomery R-1

    static umod_t mg_r;          // Montgomery R mod m
    static umod_t mg_r_prime;    // Montgomery R^-1 mod m
    static umod_t mg_m;          // Montgomery modulus
    static umod_t mg_m_prime;    // Montgomery -modulus^-1 mod R
    */

    // magic initialiser, MUST be the last thing
    static mod_init mod_zero;     
};
//---------------------------------------------


int operator == (const mod &h1, const mod &h2);
int operator != (const mod &h1, const mod &h2);

mod operator + (const mod &h);
mod operator - (const mod &h);

mod operator + (const mod &h1, const mod &h2);
mod operator - (const mod &h1, const mod &h2);
mod operator * (const mod &h1, const mod &h2);
//mod operator / (const mod &h1, const mod &h2);

mod operator + (const mod &h, const mod_t i);
mod operator + (const mod_t i, const mod &h);
mod operator - (const mod &h, const mod_t i);
mod operator - (const mod_t i, const mod &h);
mod operator * (const mod &h, const mod_t i);
mod operator * (const mod_t i, const mod &h);
//mod operator / (const mod &h, const mod_t i);
//mod operator / (const mod_t i, const mod &h);


istream&  operator >> (istream& s, mod& x);
ostream&  operator << (ostream& s, const mod& x);


// modfuncs.cc:
mod sqr(const mod& m);
mod pow2pow(const mod& a, long ex);
mod inv(const mod& m);
mod pow(const mod& a, umod_t ex);
mod invpow(const mod& a, umod_t ex);
mod root(umod_t);
mod invroot(umod_t);
mod primitive_root();
mod inverse_primitive_root();


#endif  // !defined __MOD_H
