
#include <assert.h>

#include "mfft.h"


void 
mod_sft(mod *f, ulong n, int is)
{
    mod g[n];

    const mod rn = root(is*n);

    for(ulong k=0; k<n; ++k)
    {
	mod t; 
	t.set_x(0);

	mod w=(mod::one);

	mod dw = pow(rn,k);

	for(ulong x=0; x<n; ++x)  
	{
	    t += (w*f[x]);
	    w *= dw;
	}

	g[k]=t;
    }

    for(ulong x=0; x<n; ++x)  f[x]=g[x];

} 
// ================ end MOD_SFT ===================
