
#include <assert.h>
//#include <iostream.h>

#include "mod.h"
#include "modaux.h"
#include "modarith.h"

int
is_primitive_root(umod_t r, umod_t m, umod_t *f)
//
// used by code below
//
// tests whether r is a primitive root of m
// (optional: array of distinct factors of m-1 in f[])
//
// r is a primitive root of m  <==> 
// r^((m-1)/a)!=1 for all prime factors a of m-1
//
{
    //    cout<<"is_primitive_root(): testing r="<<r<<endl;

    if ( f==NULL )
    {
	f = distinct_prime_factors(m-1);
    }

    for (ulong fct=0; ; fct++)
    {
	umod_t v = f[fct];

	if( v==0 )  return 1;  // all factors tested

	mod x=pow((mod)r,(m-1)/v);
        //        smod_t x = s_pow_mod_m((smod_t)r,(m-1)/v,(smod_t)m);

        //	cout<<" test for factor["<<fct<<"]= "<<f[fct]
        //	    <<" (ex="<<(m-1)/v<<")"
        //	    <<" gave:"<<x
        //	    <<endl;
	
	if ( x==(mod::one) )  return 0;  // no primitive root
        //	if ( x==1 )  return 0;  // no primitive root
    }

    assert( 0 );
}
//================= end IS_PRIMITIVE_ROOT ================



umod_t
find_primitive_root(umod_t m)
//
// finds a primitive root of m
//
{
    umod_t *f = distinct_prime_factors(m-1);

    for (umod_t r=2; r<m; r++)
    {
	if ( is_primitive_root(r,m,f) )  return r;
    }

    return 0;
}
//================= end FIND_PRIMITIVE_ROOT ================
