#include <math.h>
#include <assert.h>
#include <iostream.h>

#define MOD_FFT(x,y,z)   mod_fft_dit2(x,y,z) 

#include "builtin.h"
#include "mfft.h"
#include "modaux.h"

void
copy(mod f[], mod g[], ulong n)
{
    while ( n-- )  g[n]=f[n];
}
//===========================


void
print(mod f[], ulong n)
{
    for ( ulong i=0; i<n; i++ )
    {
	cout << f[i]<<", ";
    }
}
//===========================


mod
sum(mod f[], ulong n)
{
    mod s;  
    s.set_x(0);

    while ( n-- )  s+=f[n];

    return s;
}
//===========================



int 
main()
{
    ulong ldn=4, n=(1<<ldn);
    mod *f, *g, *h;

    f = new mod[n];
    g = new mod[n];
    h = new mod[n];
    
    for (ulong i=0; i<n; ++i)
    {  
	f[i].set_x(0);
	g[i].set_x(0);
	h[i].set_x(0);
    }

    f[0].set_x(1);
    g[0].set_x(1);
    h[0].set_x(1);
      
    f[1].set_x(1);
    g[1].set_x(1);
    h[1].set_x(1);

    //    f[2].set_x(1);
    //    g[2].set_x(1);
    //    h[2].set_x(1);


    for (ulong k=0; k<ldn; ++k)
    {
	fft_mod_convolution(f,g,h,ldn);
	print(h,n);
	mod s=sum(h,n);
	cout << " k=" <<k<<": "
	     << "  s=" << s << endl;
	copy(h,g,n);
    }

    return 0;
}
//-------------------------------------------
