
#include <math.h>

#include "fxt.h"
#include "fxtaux.h"

void 
fht_real_complex_fft(double *f, ulong ldn)
//
// ordering on output:
// f[0]     = re[0] 
// f[1]     = re[1] 
//         ... 
// f[n/2-1] = re[n/2-1] 
// f[n/2]   = re[n/2](==nyquist freq) 
//
// f[n/2+1] = -im[n/2-1]  (wrt. compl fft with is=-1)
// f[n/2+2] = -im[n/2-2] 
//         ... 
// f[n-1]   = -im[1]
//
// corresponding real and imag parts (with the exception of
// zero and nyquist freq) are found in f[i] and f[n-i]
//
// note that the order of imaginary parts 
// is reversed wrt. fft_real_complex_fft()
//
{
    fht(f,ldn);

    const ulong n=(1<<ldn);
    const ulong k=(n>>1);
    for (ulong i=1,j=n-1; i<k; i++,j--)
    {
        sumdiff2_05(f[i],f[j]);
    }
}
/* =============== end FHT_REAL_COMPLEX_FFT =========== */


void 
fht_real_complex_fft0(double *f, ulong ldn)
//
// version for zero padded data
//
// ordering on output: 
// see fht_real_complex_fft() 
//
{
    fht0(f,ldn);

    const ulong n=(1<<ldn);
    const ulong k=(n>>1);
    for (ulong i=1,j=n-1; i<k; i++,j--)
    {
        sumdiff2_05(f[i],f[j]);
    }
}
/* =============== end FHT_REAL_COMPLEX_FFT0 =========== */


void 
fht_complex_real_fft(double *f, ulong ldn)
//
// ordering on input: 
// like the output of fht_real_complex_fft()
//
{
    const ulong n=(1<<ldn);
    const ulong k=(n>>1);
    for (ulong i=1,j=n-1; i<k; i++,j--)
    {
        sumdiff2(f[i],f[j]);
    }
    
    fht(f,ldn);
}
/* =============== end FHT_COMPLEX_REAL_FFT =========== */
