#include <math.h>
#include <stdlib.h>
#include <assert.h>
#include <iostream.h>

#include "fxt.h"
#include "fxtaux.h"

#define X01(x)  (x>0?1:0)

/*
redirect output into a *.pbm file,
it will contain the basis functions
of the walsh transformation used
 */

#include "testaux.cc"


int 
main(int argc, char **argv)
{
    ulong ldn=5;

    //    cerr<<" enter ldn (eg. 5 for 32):"<<endl;
    //    cin>>ldn;

    if ( argc>1 )  ldn=atoi(argv[1]); 


    long n=(1<<ldn);
    //    ulong n2=2*n;
    double f[n]; //g[n];

    /*
    for(ulong i=0; i<n; ++i)
    {
	cout<<"i="<<i<<" "<<graycode(i)<<"=gc"<<endl;
	assert( i == inverse_graycode(graycode(i)) );
    }
    return 0;
    */

    // --- write pbm header:
    cout << "P1"<<endl;
    cout << "# (length-" << n << 
        ") walsh- functions, their (index)  and their {sequency}" << endl;
    cout << n << " " << n << endl;
    // --- end write pbm header:


    for ( long k=n-1; k>=0; --k )
    {
	d_null(f,n);
	//    d_null(g,n);

	//	cerr<<"k="<<k<<" "<<graycode(k)<<"=gc"<<endl;
	//	f[graycode(k)] = 1.0;
	f[k] = 1.0;
	//	print("",f,n);

	//	scramble(f,n);
	//	dif2_walsh_wak(f,ldn);  // wak- functions


	//	gray_scramble(f,n);
	//	dit2_walsh_pal(f,ldn);       // pal- functions

	dif2_walsh_wak(f,ldn);       // wal- functions


	long z = X01(f[0]);
	long s = 0;  // counts sign changes

	// write a pbm row :
	for ( long i=0; i<n-1; ++i )
	{
	    z = X01(f[i]);
	    if ( z!=X01(f[i+1]) )  s++; 
	    cout << z ;
	}

	cout << X01(f[n-1]);

	// append comment to pbm row:
	cout <<" # ("<<k<<") {"<<s<<"}"<<endl;
    }
}
