
#include <assert.h>

#include "hfgutsfu.h"
#include "hfdatafu.h"
#include "mybuiltin.h"


long gt_cmp(const hfguts &a, const hfguts &b)
// 
// return  0 if a=b
//        +1 if a>b
//        -1 if a<b
//
{

    if (a.sign()!=b.sign())
    {
        return SIGN(a.sign()-b.sign());
    }
    else
    {
        if (a.is_zero() && b.is_zero())  return 0;
        else                             return a.sign()*SIGN(gt_cmp_abs(a,b));
    }

}
//================= end GT_CMP =================



long gt_cmp_abs(const hfguts &a, const hfguts &b)
//
// cmp absolute values of two numbers
//
// return:  +1 if |a|>|b|
//           0 if |a|=|b|
//          -1 if |a|<|b|
//
{
    if (a.is_zero())
    {
        if (b.is_zero())  return 0;
        else              return -1;
    }
    
    if (b.is_zero())
    {
        return +1;
    }

    assert(a.normalized()); // numbers must be normalized
    assert(b.normalized());

    if (a.exp()!=b.exp())          // ? different exponents 
    {
        return SIGN(a.exp()-b.exp());
    }
    else                 // ? different digits
    {
        return SIGN(dt_cmp(*a.data(), a.prec(), *b.data(), b.prec()));
    }

    return 0;
}
//=========================== end GT_CMP_ABS ======================



