
#include <assert.h>

#include "hfgutsfu.h"


long gt_cmp_999(const hfguts &a, ulong st);
long gt_cmp_100(const hfguts &a, ulong st);



long gt_cmp_one(const hfguts &a, ulong st)
//
//  st= startdigit
//
//  return -1 if   sign or exponent wrong
//            else number of first different digit
//
{
    // sign ok ?:
    if(a.sign()!=+1)  return -1;

    if(st>=a.prec())  st=a.prec()-1;

    long pr=-1;

    // ? number= .99999999*RADIX^0:
    if( 0==a.exp() )  pr=gt_cmp_999(a,st); 

    // ? number= .10000000*RADIX^1:
    if( 1==a.exp() )  pr=gt_cmp_100(a,st); 

    return pr;
}
//====================== end GT_CMP_ONE ==========================



long gt_cmp_999(const hfguts &a, ulong st)
//
// return:   index of first diff digits
//
{
    ulong k;
    LIMB *ad=a.data()->dig();
    const int nine=hfdata::rx-1;

    for(k=st; k<a.prec(); ++k)
    {
        if(ad[k]!=nine)  break;
    }

    return k;
}
//====================== end GT_CMP_999 ==========================


long gt_cmp_100(const hfguts &a, ulong st)
//
// return:   index of first diff digits
//
{
    ulong k;
    LIMB *ad=a.data()->dig();


    if(st==0)
    {
        st=1;   // avoid testing most significant digit in loop

        // test first digit:
        if(ad[0]!=1)  return 0;
    }


    for(k=st; k<a.prec(); ++k)
    {
        if(ad[k]!=0)  break;
    }

    return k;
}
//====================== end GT_CMP_100 ==========================
