
#include <math.h>
#include <iostream.h>
#include <strstream.h>
#include <assert.h>
#include <ctype.h>
#include <stdlib.h>  // exit()
#include <string.h>  // strcspn()

#include "hfguts.h"
#include "mybuiltin.h"

// for debug:
#define PR(x)  


void fatal_error(const char *bla);
long discard_surrounding_blanks(const char **strp);
long read_rx_ex(const char* str, long len, long &rx, long &ex);
long read_dot_sgn(const char* str, long mlen, int &s);
long set_exponent(long dt, long fnz, long ex, long rx, long &xm);


ulong
gt_from_string(const char *str, hfguts &a)
//
// must be of the form
// [+|-] mantissa [ (*rx^) | E | e [+|-]ex]
// where rx is a power of 10
//
// this routine might be fooled be strange (invalid) strings
//
// returns # of LIMBs produced
{
    PR( cout << endl; );

    assert( a.writeable() );
    assert( hfdata::rxbase==10 );  // only for base a power of 10 !

    long len = discard_surrounding_blanks(&str);
    PR( cout << " gt_from_string(): len=" << len << endl; );
    assert( len>0 );


    // --- read radix and exponent:
    long ex;
    long rx;
    long mlen;  // length of mantissa
    mlen = read_rx_ex(str,len,rx,ex);
    PR( cout << " gt_from_string(): mlen=" << mlen << endl; );


    // --- dec dot and sign:
    long dt;
    int s;
    dt = read_dot_sgn(str, mlen, s);
    a.sign(s);

    if ( dt==mlen-1 )   // handle trailing dec pt
    {
        mlen--;
        PR( cout << " gt_from_string():  mlen=" << mlen << endl; );
        if ( mlen<=0 )  fatal_error(" ? no digits (mlen)");
    }


    // --- scan mantissa for first nonzero digit:
    long fnz;  // first nonzero digit
    fnz = strcspn(str,"123456789");
    PR( cout << " gt_from_string(): fnz=" << fnz << endl; );

    if ( fnz>=mlen )  // no digit different from '0' found
    {
        PR( cout << " gt_from_string(): zero. " << endl; );
        a.set_zero();
        return 1;
    }


    // --- set exponent:
    long xm;
    long xx;
    xx = set_exponent(dt,fnz,ex,rx,xm);
    a.exp( xx );
    PR( cout << " gt_from_string(): LIMB exp= " << a.exp() << endl; );


    // ----- read the LIMBs
    LIMB *ad = a.data()->dig();
    long pr = a.prec();
    int  hrx = (hfdata::rx);
    int  bp  = (hfdata::rxbspw);

    char ls[10];  // magic, assume 10>=bp+1 
    for(long k=0; k<bp; ++k)  ls[k]='0'; // prepend zeros
    ls[bp] = 0;  // terminate string

    long j,x;
    for(x=0,j=fnz; x<1 && j<mlen ; ++x)  // --- read the first LIMB
    {
        long y;
        for(y=xm; y<bp && j<mlen ; ++y, ++j)  // get string for one LIMB
        {
            char c = str[j];
            if ( '.'==c )
            {
                ++j;
                if ( j==mlen )  c = 0;
                else            c = str[j];
            }

            ls[y] = c;
        }

        while ( y<bp )  { ls[y]='0';  ++y; }  // fill if incomplete
        PR( cout << " gt_from_string(): 1.LIMB=" << ls << endl; );

        long d;
        istrstream(ls) >> d;  // convert
        assert( d>=0 );
        assert( d<hrx );
        ad[x] = d;
    }

    for ( ; x<pr && j<mlen ; ++x)  // --- read the LIMBs
    {
        long y;
        for (y=0; y<bp && j<mlen ; ++y, ++j)  // get string for one LIMB
        {
            char c = str[j];
            if ( '.'==c )
            {
                ++j;
                if ( j==mlen )  c = 0;
                else            c = str[j];
            }

            ls[y] = c;
        }

        while ( y<bp )  { ls[y]='0';  ++y; }  // fill if incomplete
        PR( cout << " gt_from_string(): LIMB=" << ls << endl; );

        long d;
        istrstream(ls) >> d;  // convert
        assert( d>=0 );
        assert( d<hrx );
        ad[x]=d;
    }

    PR( cout << " gt_from_string(): appending " << pr-x << " zero LIMBs " << endl; );
    //    if ( x<pr )  i_null(ad+x,pr-x);  // fill remaining digits with zeros
    if ( x<pr )  (*a.data()).fill(x,pr,0);  // fill remaining digits with zeros

    assert( a.normalized() );
    return x+1;
}
//================== end GT_FROM_STRING =======================


void
fatal_error(const char *bla)
{ 
    cerr << "\n ! ERROR in gt_from_string(): " 
         << bla << endl;

    exit (-1);
}
// ----------------


long
discard_surrounding_blanks(const char **strp)
//
// set *str to first nonblank char
// return # of nonblank chars
//
{
    const char *str = *strp;
    long j;
    long len = strlen(str);

    if ( len<=0 )  goto hier;

    // --- forget leading blanks:
    j = strspn(str," \t");
    str += j;
    len -= j;
    if ( len<=0 )  goto hier;

    // --- forget trailing blanks:
    len = strcspn(str," \t");
    if ( len<=0 )  goto hier;

hier:
    *strp = str;
    return len;
}
// ----------------
 

long
read_rx_ex(const char* str, long len, long &rx, long &ex)
//
// read "*10^NNN" , "eNNN" or so
// set rx=radix, ex=exponent
// return index of first char after mantissa
//
{
    long k = strcspn(str, "eE^");

    if ( k>=len )  // no exponent given
    {
        ex=0;
        PR( cout << " gt_from_string(): default ex=" << ex << endl; );
        rx=10;
    }
    else
    {
        istrstream(str+k+1) >> ex;
        PR( cout << " gt_from_string(): ex=" << ex << endl; );
        k = strcspn(str, "eE*");
        if ( k==len ) fatal_error("invalid exponent");

        if ( '*'==str[k] )  // "*rx^ex" 
        {
            istrstream(str+k+1) >> rx;
            PR( cout << " gt_from_string(): '*' rx=" << rx << endl; );
        }
        else    // "E" or "e"
        {
            rx = 10;
            PR( cout << " gt_from_string(): 'E' rx=" << rx << endl; );
        }
    }

    return k;
}
// ----------------


long
read_dot_sgn(const char* str, long mlen, int &s)
//
// handle sign 
// and decimal dot
// return position of decimal dot
//
{
    long dt;
    const char *cdt = strchr(str,'.');
    if ( cdt==NULL )  // no dot
    {
        dt = mlen;  // set dt at end of mantissa
    }
    else
    {
        dt = cdt-str;  // str[dt]=='.'
        assert( !strchr(cdt+1,'.') );  // no two dots 
    }
    
    PR( cout << " gt_from_string(): dec pt=" << dt << endl; );

    s = +1;
    long i = 0;
    switch( str[i] )                   // test for sign
    {
    case '+' :  ++i;  break;
    case '-' :  ++i;  s = -1;  break;
    case '.' :  ++i;  break;
    default  :  assert( isdigit(str[i]) ); // must be valid digit
    }
    PR( cout << " gt_from_string(): sign=" << s << endl; );
    if ( i==mlen )  fatal_error(" ? no digits (i)");

    switch(str[i])                   // skip leading dec pt
    {
    case '.' :  ++i; break;
    default  :  assert( isdigit(str[i]) ); // must be valid digit
    }

    // here i points to first digit of the mantissa 
    if ( i==mlen )  fatal_error(" ? no digits (i)");
    assert( isdigit(str[i]) );

    return dt;
}
// ----------------


long
set_exponent(long dt, long fnz, long ex, long rx, long &xm)
//
// return exponent wrt. hfdata::rx
// needs position of first nonzero digit (fnz),
// ex and rx from string 
// xm is set to the (positive) number
//    (exponent_for_10) % (hfdata::rxbspw)
//
{
    long dx = dt-fnz;   // contribution for exponent from dec pt
    if ( dx<0 )  dx++;
    PR( cout << " gt_from_string(): dx=" << dx << endl; );

    int p = ispowof(rx,10);
    assert( p );
    PR( cout << " gt_from_string():  p=" << p << endl; );

    long tx = dx+p*ex;  // exponent for 10
    PR( cout << " gt_from_string(): tx=" << tx << endl; );


    // --- set exponent according to tx
    int  bp = (hfdata::rxbspw);
    long xd = tx/bp;
    xm = tx%bp;

    if ( xm>0 )
    {
        xm -= (hfdata::rxbspw);
        xd++;
    }
    PR( cout << " gt_from_string(): xd=" << xd << endl; );
    xm = -xm;
    PR( cout << " gt_from_string(): xm=" << xm << endl; );

    return xd;
}
// ----------------



/*
int
gt_to_string(const hfguts &a, char *str)
{
    assert(0*(int)" ! not implemented ! ");  // XXX

    str = (char *)(0* (int)(&a));  // avoid compiler warning

    return 0;
}
//================== end GT_TO_STRING =======================
*/
