
#include <assert.h>

#include "hfgutsfu.h"
#include "hfdatafu.h"
#include "mybuiltin.h"



int gt_div_int(const hfguts &a, long i, hfguts &c, int *rem)  // =0
//
// c=a/b
// rem=a%b
//
{
    assert( c.writeable() );
    assert( i );

    int dx;
    unsigned long u;

    c.copy(a);

    c.sign(a.sign()*SIGN(i));
    c.exp(a.exp());

    u = ABS(i);

    dx = dt_div_sh(*c.data(),c.prec(),u,rem);

    c.exp(c.exp()-dx);

    return 0;
}
//================== end GT_DIV_INT ===================


