
#include <assert.h>

#include "hfloat.h"
#include "hfgutsfu.h"

#define A  *(a.guts())


int
i2hfloat(long i, hfloat &a)
//
// returns how many LIMBS were made
//
{
    return gt_from_int(i,A);
}
//============== end U2HFLOAT ===============


int
u2hfloat(ulong i, hfloat &a)
//
// returns how many LIMBS were made
//
{
    return gt_from_uint(i,A);
}
//============== end I2HFLOAT ===============


void
i2hfloat_prec_adj(long i, hfloat &xi)
//
// used for static hfloats in some places
//
{
    xi.prec( xi.size() );
    ulong xl = i2hfloat(i,xi);
    xi.prec(xl);
}
//=============== end I2HFLOAT_PREC_ADJ ====================



int
hfloat2i(const hfloat &a, long &i)
{
    return gt_to_int(A,i);
}
//=================== end HFLOAT2I ===============


int
hfloat2d(const hfloat &a, double &d)
{
    //    gt_to_double(A,d);
    //    cout << "\n hfloat2d(): d= " << d << endl; cout.flush();
    return gt_to_double(A,d);
}
//=================== end HFLOAT2D ===============


int
d2hfloat(double d, hfloat &a)
//
// returns how many LIMBS were made
//
{
    return  gt_from_double(d,A);
}
//================= end D2HFLOAT ===============


int
st2hfloat(const char *str, hfloat &a)
//
// returns how many LIMBS were made
//
{
    return gt_from_string(str,A);
}
//================= end ST2HFLOAT ===============
