
#include <math.h>

#include "hfloatfu.h"

//
// this relation holds:
// x == floor(x) + frac(x)
//

int
floor(const hfloat &x, hfloat &a)
//
//
//  return:
//   0 if input was an integer
//   1 else
//
{
    a = x;

    if ( integerq(a) )  return 0;


    long  di = a.exp();  // number of LIMBS containing integral part

    if ( di<(long)a.prec() )
    {
	    a.guts() -> data() -> fill(di, a.prec()-1, 0);
    }

    a.guts()->normalize();

    return 1;
}
//====================== end FLOOR ==========================


int
frac(const hfloat &x, hfloat &a)
//
//
//  return:
//   0 if input was an integer
//   1 else
//
{
    a = x;

    if ( integerq(a) )     // no fractional part
    {
        a.set_zero();
        return 0;
    }

    long  di = a.exp();  // number of LIMBS containing integral part
    //        i_shift_left(a.guts()->data()->dig(),a.prec(),di);
    (*a.guts()->data()).shift_left( a.prec(),di );
    a.exp(0);
    a.guts()->normalize();
    return 1;
}
//====================== end FRAC ==========================
