
#include <iostream.h>
#include <assert.h>
#include <math.h>

#include "hfloat.h"
#include "convolut.h"   // XXX_CNVL
#include "workspace.h"  // max_prec()

// for debug:
#define PR(x)
#define PRCD(x)

#define SAFE(x) x


// initialisation of static members in init.cc !
// (because of the special initialisation mechanism)
char *hfloat::version_string = "20-august-1997";
ulong hfloat::max_precision = 0;
int   hfloat::check_itiroot_result = 0;

// the instance 'hfloat_initialiser'
// of the class hfloat_init
// initialises the 'hfloat' class:
// it MUST be the initialised as the last static member of class hfloat !
hfloat_init hfloat::hfloat_initialiser
= hfloat_init(           // what_it_is       (default)
              1,         // whether to say hello (1)
              10000,     // default radix (10000)
              1024,      // max precision in LIMBs (1024)
              FHT_CNVL,  // type of convolution for sqr (FHT_CNVL)
              FHT_CNVL,  // type of convolution for mul (FHT_CNVL)
              1,         // whether to check fxt mult via sum of digit test (1)
              0          // whether to check iterations for inverse n-th root (0)
              );




void
hfloat::hello()
{
    cout << "\n ----====== HUGE_FLOAT ver " << hfloat::version() << " ======---- ";
    cout << "\n    author: Joerg Arndt, email: arndt@jjj.de ";
#ifdef __GNUC__
#define  XSTR(s)  STR(s)
#define  STR(s)  #s
    cout << "\n compiled using GNU C++ version "  XSTR(__VERSION__) ;
    cout << "\n at " << __DATE__ << ", " << __TIME__ ;
#endif
    cout << "\n    hfloat is online at http://www.jjj.de/hfloat/";
    cout << "\n    (check my homepage for the latest version of hfloat) ";
//    cout << "\n  use --help for usage ";
    cout << endl;
}
//--------------


int
hfloat::id() const
{
    return hfid;
}
//--------------


void
hfloat::set_unique_id()
{
    static int idnum = 0;

    ++idnum;
    hfid = idnum;
}
//--------------

const char *
hfloat::version()
{
    return version_string;
}
//--------------

hfloat::hfloat()
{
    set_unique_id();

    PRCD( cout<<"\n#"<< id() <<"=hfloat() "; );

    ulong p = max_prec();
    assert( p*(int)" strange max_prec " );

    gt = new hfguts(p);  assert( gt );
//    hfloat( max_prec() );
}
//--------------


hfloat::hfloat(ulong n)
//
// explicit only
//
{
    set_unique_id();

    PRCD( cout<<"\n#"<< id() <<"=hfloat(n="<<n<<") "; );

    if ( n )
    {
        gt = new hfguts(n);  assert( gt );
    }
    else
    {
        gt = 0;
    }
}
//--------------


hfloat::hfloat(const hfloat &h)
{
    set_unique_id();
    //    hfid = -h.id();

    PRCD( cout<<"\n#"<< id() <<"=hfloat(h="<<h.id() <<") "; );

    assert(h.gt);
    SAFE( h.check(); );

    gt = new hfguts(*(h.gt));  assert( gt );
    SAFE( check(); );
}
//--------------


hfloat::~hfloat()
{
    PRCD( cout<<"\n#"<< id()<<": ~hfloat "; );

    delete gt;
}
//-------


void
hfloat::ensure_own_data(ulong n/*=0*/)
//
//
//
{
    if ( gt->data()->mydata() )  return;  // nothing to do

    make_own_data(n);
}
//--------------


void
hfloat::make_own_data(ulong n/*=0*/)
//
//
//
{
    if ( n==0 )  n = size();

    hfdata *d = new hfdata(n);  assert( d );

    (*d).copy(*(gt->data()),d->size());


    gt->unlink();
    gt->link(*d,0);
}
//--------------

void
hfloat::copy(const hfloat &h)
{
    if ( id()==h.id() )  return;

    gt->copy( *h.guts() );
}
//--------------

int
hfloat::same_mantissa(const hfloat &h) const
//
// return 1 if mantissas of *this and h are the same piece of memory
//
{
    if ( id()==h.id() )  return 1;

    return gt->same_mantissa( *h.guts() );
}
//--------------

int
hfloat::positive() const
{
    return (gt->sign()) >0;
}
//--------------


int
hfloat::negative() const
{
    return (gt->sign()) <0;
}
//--------------


int
hfloat::is_zero() const
{
    return gt->is_zero();
}
//--------------


void
hfloat::set_zero()
{
    gt->set_zero();
}
//--------------


void
hfloat::negate()
{
    gt->negate();
}
//--------------


int
hfloat::sign() const
{
    return gt->sign();
}
//--------------


void
hfloat::sign(int s)
{
    gt->sign(s);
}
//--------------


long
hfloat::exp() const
{
    return (long)(gt->exp());
}
//--------------


void
hfloat::exp(long x)
{
    gt->exp((double)x);
}
//--------------


ulong
hfloat::radix()
{
    return hfdata::radix();
}
//--------------

void
hfloat::radix(ulong r)
{
    if ( hfdata::rx==r )  return;  // nothing to do

    cout << " radix set to "
	 << r << endl;

    hfdata::radix(r);
}
//--------------


void
hfloat::prec(ulong p)
{
    gt->prec(p);
    //    else die_in_pain...
}
//--------------

ulong
hfloat::prec() const
{
    return gt->prec();
}
//--------------


void
hfloat::dec_prec(ulong p)
{
    prec( (ulong)ceil(p*log(10.0)/log(radix())) );
}
//--------------

ulong
hfloat::dec_prec() const
{
    double p = prec()*log(radix())/log(10.0);

    return (long)p;
}
//--------------


void
hfloat::bit_prec(ulong p)
{
    prec( (ulong)ceil(p*log(2.0)/log(radix())) );
}
//--------------

ulong
hfloat::bit_prec() const
{
    double p = prec()*log(radix())/log(2.0);

    return (long)p;
}
//--------------


void
hfloat::size(ulong n)
{
    gt->data()->size(n);
}
//--------------

ulong
hfloat::size() const
{
    return gt->data()->size();
}
//--------------


LIMB
hfloat::get_limb(ulong n) const
{
    //    if ( n<0 )  n = gt->prec()-n;  // allow negative index

    if ( n>gt->prec() )  return 0; // index>prec --> return 0
    else                 return (gt->data()->dig())[n];
}
//--------------


void
hfloat::set_limb(ulong n, LIMB x)
{
    //    if ( n<0 )  n = gt->prec()-n;  // allow negative index

    if ( n<=gt->prec() )  (gt->data()->dig())[n] = x;
    else  assert( 0*(int)"hfloat::set_limb(): index out of range" );
}
//--------------


void
hfloat::check() const
{
    assert( gt );
    gt->check();
}
//--------------


hfguts*
hfloat::guts() const
{
    assert( gt );

    return gt;
}
//--------------


ulong
hfloat::max_prec()
{
    return workspace::max_prec();
}
//--------------



#define DEC_PREC(n,rx)  ((long)(floor((double)n*log(rx)/log(10.0))))
#define HEX_PREC(n,rx)  ((long)(floor((double)n*log(rx)/log(16.0))))
#define BIT_PREC(n,rx)  ((long)(floor((double)n*log(rx)/log(2.0))))

void
hfloat::max_prec(ulong n)
{
    if ( max_prec()==n )  return;

    gws.setup(n);
    gws.info(n);

    ulong rx = radix();
    cout << " max precision set to "
         << n << " LIMBs ="
         <<  DEC_PREC(n,rx) << " decimal digits "
         << "  =" << BIT_PREC(n,rx) << " bits "
         << endl;

    if( hfdata::rx2pw )
    {
        cout << "  =" 
             << BIT_PREC(n,rx)/4 << " hex digits "
             << endl;
    }

}
//--------------


void
hfloat::statistics(ulong n)
{
    hfdata::statistics(n);
}
//--------------
