
#include <assert.h>

#include "hfloatfu.h"
#include "hfverbosity.h"
#include "hfdatafu.h"
#include "workspace.h"  // gws 
#include "mybuiltin.h"
#include "convolut.h"   // set_mul_convl()



hfloat_init::hfloat_init(int helloq, LIMB rx, ulong prec,
                         int cnvl, int acnvl, 
                         int check_mul, int check_roots)
{
    //    cout << " START HFLOAT_INIT::HFLOAT_INIT():" << endl;

    static int once_only_flag = 0;

    assert( once_only_flag==0 );
    once_only_flag = 1;

    if ( helloq )  hfloat::hello();

    hfloat::radix(rx);

    hfloat::max_prec(prec);
//    hfloat::default_prec(prec);

    // choose convolution used for multiplies:
    set_mul_convolution(cnvl);

    // choose (auto-)convolution used for quarings:
    set_sqr_convolution(acnvl);

    // whether to check multiplies via sum of digit:
    hfdata::checkmult = check_mul;
//    cout << " fxt multiplies ";
//    if ( check_mul )  cout << "ARE ";
//    else             cout << "are NOT ";
//    cout << "checked via sum of digit test " << endl;


    // whether to check that the last step in iteration really 
    // produced (almost) a full precision result.
    // this decreases performance by about 30% 
    hfloat::check_itiroot_result = check_roots;
//    cout << " iterations for inverse n-th root ";
//    if ( check_roots )  cout << "ARE ";
//    else                cout << "are NOT ";
//    cout << "checked " << endl;


    //    hfverbosity::tell_pi();  // echo pi related stuff 
    //    hfverbosity::tell_all();  // do echo operations
    hfverbosity::hush_all();  // do not echo any operations


    start_timer();

    //    cout << " END HFLOAT_INIT::HFLOAT_INIT():" << endl;
}
//=========== end HFLOAT_INIT() ============


hfloat_init::~hfloat_init()  // 'hfloat_exit()'
{
}
//=========== end ~HFLOAT_INIT() =============

