#if !defined __HFDATA_H
#define      __HFDATA_H


#include "types.h"     // says LIMB:=unsigned short


class hfdata
{
public:

    hfdata(ulong n);
    hfdata(LIMB *d, ulong n);

    ~hfdata();

    void  hfdata::copy(const hfdata &, ulong);
    void  hfdata::addlink();
    long  hfdata::sublink();
    LIMB *hfdata::dig() const;
    void  hfdata::size(ulong);
    ulong hfdata::size() const;
    void  hfdata::dump();
    int   hfdata::mydata() const;
    int   hfdata::check() const;
    //    ulong sum_of_digits(ulong n) const;
    void  hfdata::shift_left(ulong n, ulong s);
    void  hfdata::shift_right(ulong n, ulong s);
    void  hfdata::fill(LIMB f);
    void  hfdata::fill(ulong n1, ulong n2, LIMB f);
    void  hfdata::rand(ulong n1, ulong n2);

//    int   hfdata::radix() const;
//    void  hfdata::radix(int r, char *rfmt=0, int rdig=0);

    static int   radix(); // const;
    static void  radix(int r, char *rfmt=0, int rdig=0);

    static void  statistics(ulong n);

private:

    hfdata(const hfdata &);               // forbidden (undefined)
    hfdata & operator =(const hfdata &);  // forbidden (undefined)


    // ---- implementation:
private:

    LIMB          *dtdigit;      // the digit field
    ulong          dtsize;       // number of LIMBs 
    int            dtmydat;      // wether alloced by this
    long           dtlinks;      // how many links exist to this

public:

    LIMB           dtxdig;       // LIMB that e.g. got shifted out by mult/add


public:

    static int       checkmult;  // whether to check mult. using sum of digits

    // radix stuff:
    static ulong     rx;         // radix (same for all)
    static ulong     ldrx;       // ld(rx)
    static ulong     rxbits;     // ld(rx)[+1]
    static double    lg10rx;     // log10(rx)
    static int       rx2pw;      // = (rx is a pow of 2)?1:0;
    static ulong     rxdig;      // 
    static char     *rxfmt;      // print format
    static ulong     rxbase;     // rx=rxbase^rxbspw
    static ulong     rxbspw;     // 

    // global statistics:
    static double   nbytes;      // total bytes allocated
    static double   nbytesmax;   // max total bytes allocated
    static long     ndata;       // total number of hfdata
    static double   fxtw;        // how much work was done in fast transforms

    // convolution methods:
    // convolution procedure used for multiplication:
    static void    (* mulcnvl)(double *,double *,ulong);
     // (auto-)convolution procedure used for squaring:
    static void    (* sqrcnvl)(double *,ulong);

};
//-------------------------------------------------------------

 
#endif // !defined __HFDATA_H
