#if !defined __HFDATAFU_H
#define      __HFDATAFU_H


#include "hfdata.h"    // class hfdata

int dt_mantissa_to_double(const hfdata &a, ulong prec, double &b);
ulong dt_double_to_mantissa(double d, ulong prec, hfdata &a);


long dt_cmp(const hfdata &a, ulong ap, const hfdata &b, ulong bp);

int dt_add(const hfdata &big, ulong bp, const hfdata &sml, ulong sp, ulong dx, hfdata &c, ulong cp);
int dt_sub(const hfdata &big, ulong bp, const hfdata &sml, ulong sp, ulong dx, hfdata &c, ulong cp);

int dt_mul_fxt(const hfdata &a, ulong ap, const hfdata &b, ulong bp, hfdata &c, ulong cp);
int dt_mul_sqr(const hfdata &a, ulong ap, const hfdata &b, ulong bp, hfdata &c, ulong cp);
int dt_sqr_fxt(const hfdata &a, ulong ap, hfdata &c, ulong cp);

int dt_mul_slow(const hfdata &a, ulong ap, const hfdata &b, ulong bp, hfdata &c, ulong cp);
int dt_sqr_slow(const hfdata &a, ulong ap, hfdata &c, ulong cp);

//int dt_mul_sh(const hfdata &a, ulong ap, unsigned b, hfdata &c, ulong cp);
int dt_mul_sh(hfdata &a, ulong ap, ulong b);

int dt_div_sh(hfdata &a, ulong ap, ulong b, int *rem);

 
#endif // !defined __HFDATAFU_H
