
#include <math.h>
#include <iostream.h>
#include <assert.h>

#include "hfloatfu.h"
#include "hfverbosity.h"



int 
pi_5th_order(hfloat &p)
//
// quintic iteration for pi
// heavy use of binary operators, not at all optimized
//
{
    if ( hfverbosity::piname )  
        cout << "\n ===== pi_5th_order(): ===== " << endl;

    long n = p.prec();

    long prec;
    long pnp = hfverbosity::pinumprec;
    hfloat s(n), x(n), y(n), z(n), a(n), p5(n);


    s = 5;
    s = 5*(sqrt(s)-2);

    a = 1;
    a /= 2;

    int k;
    for (k=1;  ; ++k)
    {
        if ( hfverbosity::pistep )
            cout << "\n ----- step " << k << ": ----- " << endl;

	// A:
	p5 = 5;
	pow(p5,k-1,p5);

        //	a = sqr(s)*a-p5*((sqr(s)-5)/2+sqrt(s*(sqr(s)-2*s+5)));
        x = sqr(s);
        a = x*a-p5*((x-5)/2+sqrt(s*(x-2*s+5)));
        if ( hfverbosity::pinums )  print("\nA_k=\n",a,pnp);

	prec = 2*cmp1(s);
        if ( hfverbosity::piprec )  cout << "\n precision=" << prec << endl;
	if( prec>=n )  break;

	// X:
	x = 5/s-1;
        if ( hfverbosity::pinums )  print("\nX_k=\n",x,pnp);

	// Y:
	y = sqr(x-1)+7;
        if ( hfverbosity::pinums )  print("\nY_k=\n",y,pnp);

	// Z:
	z = root(x*(y+sqrt(sqr(y)-4*pow(x,3)))/2,5);
        if ( hfverbosity::pinums )  print("\nZ_k=\n",z,pnp);

	// S:
	s = 25/(s*sqr(z+x/z+1));
        if ( hfverbosity::pinums )  print("\nS_k=\n",s,pnp);
    }

    inv(a,p);         // ! pi !

    return k;
}
//========================== end PI_5TH_ORDER ==========================
