 
#include <math.h>
#include <assert.h>

#include "hfloatfu.h"



static ulong  piprec = 0;
static hfloat *constpi = NULL;

const hfloat &
constant_pi(ulong n)
{
    static ulong rx = 0;

    if ( NULL!=constpi )
    {
        if ( rx!=((*constpi).radix()) )  // did a radix change occur ?
        {
            piprec = 0;
        }
    }

    if ( piprec>=n )
    {
        (*constpi).prec(n);
    }
    else
    {
        if ( constpi!=NULL )  delete constpi;

        constpi = new hfloat(n);

        pi_4th_order(*constpi, 0);  // compute pi

        piprec = n;
    }

    return *constpi;
}
//============== end CONSTANT_PI ====================



static ulong  logrxprec = 0;
static hfloat *constlogrx = NULL;

const hfloat &
constant_logrx(ulong n)
{
    static ulong rx = 0;

    if ( NULL!=constlogrx )
    {
        if ( rx!=((*constlogrx).radix()) )  // did a radix change occur ?
        {
            logrxprec = 0;
        }
    }

    if ( logrxprec>=n )
    {
        (*constlogrx).prec(n);
    }
    else
    {
        if ( constlogrx!=NULL )  delete constlogrx;

        constlogrx = new hfloat(n);

        pi_by_log_q(n,*constlogrx,hfdata::rx); // pi/log(radix)
        const hfloat &pi = constant_pi(n);

        inv(*constlogrx,*constlogrx); // log(radix)/pi
        *constlogrx *= pi;            // log(radix)

        logrxprec = n;
    }

    return *constlogrx;
}
//============== end CONSTANT_LOGRX ====================



static ulong  log2prec = 0;
static hfloat *constlog2 = NULL;

const hfloat &
constant_log2(ulong n)
{
    static ulong rx = 0;

    if ( NULL!=constlog2 )
    {
        if ( rx!=((*constlog2).radix()) )  // did a radix change occur ?
        {
            log2prec = 0;
        }
    }

    if ( log2prec>=n )
    {
        (*constlog2).prec(n);
    }
    else
    {
        if ( constlog2!=NULL )  delete constlog2;

        constlog2 = new hfloat(n);

        // compute log2:
        isqrt(2, *constlog2);             // 1/sqrt(2) = 2^(-1/2)
        log(*constlog2, *constlog2);      // log(1/sqrt(2)) = -1/2*log(2)
        mul(*constlog2, -2, *constlog2);  // log(2)

        log2prec = n;
    }

    return *constlog2;
}
//============= end CONSTANT_LOG2 ===============

