
#include <assert.h>

#include "hfloatfu.h"


void
pow(const hfloat &z, const hfloat &x, hfloat &t)
{
    if ( z.is_zero() )
    {
        t = 0;
        return;
    }

    assert( (z.positive())*(int)" negative z in z^x ! " );

    hfloat tmp(t.prec());

    // z^x == exp(x*log(z)):
    log(z,tmp);
    tmp *= x;
    t = exp(tmp);
}
//=================== end POW ========================



hfloat
pow(const hfloat &h, const hfloat &p)
{
    hfloat h3;
    pow(h,p,h3);
    return h3;
}
// -----------------
